<?php
class Cliente extends TRecord
{
    const TABLENAME = 'cliente';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}

    use SystemChangeLogTrait;

    public function __construct($id = NULL)
    {
        parent::__construct($id);
        parent::addAttribute('id_estabelecimento');
        parent::addAttribute('id_zona');
        parent::addAttribute('nome');
        parent::addAttribute('endereco');
        parent::addAttribute('bairro');
        parent::addAttribute('cidade');
        parent::addAttribute('estado');
        parent::addAttribute('telefone');
    }

    public function get_nome_estabelecimento()
    {
        return (new Estabelecimento($this->id_estabelecimento))->descricao;
    }

    public function get_nome_zona()
    {
        return (new Zona($this->id_zona))->descricao;
    }
}
?>