<?php

class CaixaList extends TPage
{
    private $datagrid;

    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->primeirodia = $param["method"];

        // creates a frame
        $this->frame = new TFrame;
        $lab_cxdia = new TLabel('dia');
        $lab_cxdia->setFontSize(17);
        $lab_cxdia->setFontFace('Trebuchet MS');
        $lab_cxdia->setValue('CAIXA DO DIA - ' . substr($param["method"], 8, 2) . '/' . substr($param["method"], 5, 2) . '/' . substr($param["method"], 0, 4));
        $this->frame->add($lab_cxdia);

        // creates a DataGrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->datatable = 'true';
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        // creates the datagrid columns
//        $column_id       = new TDataGridColumn('id'       , 'Id'           , 'center');
        $column_dia      = new TDataGridColumn('dia'      , 'Dia'          , 'center');
        $column_ponto    = new TDataGridColumn('ponto'    , 'Ponto'        , 'center');
        $column_entrada  = new TDataGridColumn('entrada'  , 'Entrada'      , 'right');
        $column_saida    = new TDataGridColumn('saida'    , 'Saida'        , 'right');
        $column_apurado  = new TDataGridColumn('apurado'  , 'Apurado'      , 'right');
        $column_comissao = new TDataGridColumn('comissao' , 'Comissão'     , 'right');
        $column_saldo    = new TDataGridColumn('saldo'    , 'Saldo'        , 'right');
        $column_despesas = new TDataGridColumn('despesas' , 'Despesas'     , 'right');
        $column_pago     = new TDataGridColumn('pago'     , 'Pago'         , 'right');
        $column_deve_ant = new TDataGridColumn('deve_ant' , 'Prej Anterior', 'right');
        $column_deve_atu = new TDataGridColumn('deve_atu' , 'Prej Atual   ', 'right');
        $column_cx_atu   = new TDataGridColumn('cx_atu'   , 'Caixa Atual   ', 'right');
        $column_usuario  = new TDataGridColumn('usuario'  , 'Operador'     , 'center');

        // add the columns
//        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_ponto);
        $this->datagrid->addColumn($column_entrada);
        $this->datagrid->addColumn($column_saida);
        $this->datagrid->addColumn($column_apurado);
        $this->datagrid->addColumn($column_deve_ant);
        $this->datagrid->addColumn($column_despesas);
        $this->datagrid->addColumn($column_saldo);
        $this->datagrid->addColumn($column_comissao);
        $this->datagrid->addColumn($column_pago);
        $this->datagrid->addColumn($column_deve_atu);
        $this->datagrid->addColumn($column_cx_atu);
        $this->datagrid->addColumn($column_dia);
        $this->datagrid->addColumn($column_usuario);

        $column_dia->setTransformer( function($value, $object, $row) {
            return substr($value,8,2).'/'.substr($value,5,2).' - '.substr($value,11,5);
        });
        $column_ponto->setTransformer( function($value, $object, $row) {
            If(substr($value,0,3) == '***'){$row->style = "color: white; background: red";};
            If(substr($value,0,13) == '*** TOTAL ***'){$row->style = "background: lightblue";};
            return $value;
        });


        $column_entrada->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_saida->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_apurado->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_comissao->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_saldo->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_despesas->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_pago->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_deve_ant->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_deve_atu->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});
        $column_cx_atu->setTransformer( function($value, $object, $row) {return number_format($value, 2, ',', '.');});

        // creates the datagrid model
        $this->datagrid->createModel();

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->frame);
        $vbox->add($this->datagrid);
        parent::add($vbox);
    }

    function onReload($param)
    {

        TTransaction::open('jackpot');

        $dia00=$this->primeirodia.' 00:00:00';
        $dia99=$this->primeirodia.' 23:59:59';

        // Recupera Lançamentos
        $repository = new TRepository('Movimento');
        $criteria = new TCriteria;
        $criteria->setProperty('order', 'usuario asc');
        $criteria->add(new TFilter('dia', 'BETWEEN', $dia00, $dia99));
        $customers = $repository->load($criteria);

        $this->datagrid->clear();
        $quebra = '';
        $pula=1;
        $sub_entrada=0;
        $sub_saida=0;
        $sub_apurado=0;
        $sub_despesas=0;
        $sub_saldo=0;
        $sub_comissao=0;
        $sub_pago=0;
        $tot_entrada=0;
        $tot_saida=0;
        $tot_apurado=0;
        $tot_despesas=0;
        $tot_saldo=0;
        $tot_comissao=0;
        $tot_pago=0;
        $conteudo='';
        foreach ($customers as $customer) {
            if($quebra != $customer->usuario){
                $quebra = $customer->usuario;
                if($pula == 1){
                    $pula=0;
                } else {
                    $obj = new StdClass;
                    $obj->ponto = '*** TOTAL ***';
                    $obj->dia = date('Y-m-d H:i:s');
                    $obj->entrada = $sub_entrada;
                    $obj->saida = $sub_saida;
                    $apurado = $sub_apurado;
                    $obj->apurado = $apurado;
                    $obj->deve_ant = 0;
                    $obj->despesas = $sub_despesas;
                    $obj->saldo = $sub_saldo;
                    $obj->comissao = $sub_comissao;
                    $obj->pago = $sub_pago;
                    $obj->cx_atu = 0;
                    $obj->deve_atu = 0;
                    $obj->usuario = $usuario->name;
                    $row = $this->datagrid->addItem($obj);

                    if($sub_despesas != 0){
                        $row->popover = 'true';
                        $row->popside = 'top';
                        $row->popcontent = '<tr><th>Ponto</th><th>Descrição</th><th>Valor</th></tr>'.$conteudo.'</table>';
                        $row->poptitle = 'Despesas';
                        $conteudo = '';
                    }

                    $sub_entrada=0;
                    $sub_saida=0;
                    $sub_apurado=0;
                    $sub_despesas=0;
                    $sub_saldo=0;
                    $sub_comissao=0;
                    $sub_pago=0;
                }
            }
            $obj = new StdClass;
            $obj->id = $customer->id;
            $ponto = new Ponto($customer->id_ponto);
            $obj->ponto = $ponto->nome;
            $obj->dia = $customer->dia;
            $obj->entrada = $customer->entrada;
            $obj->saida = $customer->saida;
            $apurado = $customer->entrada - $customer->saida;
            $obj->apurado = $apurado;
            $obj->deve_ant = $customer->deve_anterior;
            $obj->despesas = $customer->despesas;
            $saldo = $apurado + $customer->deve_anterior - $customer->despesas;
            $obj->saldo = $saldo;
            $obj->comissao = $customer->comissao;
            $obj->pago = $customer->pago;
            $obj->cx_atu = $customer->cx_atual;
            $obj->deve_atu = $customer->deve_atual;
            $usuario = new SystemUser($customer->usuario);
            $obj->usuario = $usuario->name;
            $row = $this->datagrid->addItem($obj);
            // Despesas
            if($customer->despesas != 0){
                // Recupera Despesas
                $repository = new TRepository('Despesa');
                $criteria = new TCriteria;
                $criteria->add(new TFilter('id_movi', '=', $customer->id));
                $debitos = $repository->load($criteria);
                foreach ($debitos as $debito) {
                    $quem = new Ponto($debito->id_ponto);
                    $conteudo = $conteudo.'<tr><td>'.$quem->nome.'</td><td> | '.$debito->descricao.'</td><td> | '.number_format($debito->valor,2,',','.').'</td></tr>';
                }
            }
            // Sub-totais
            $sub_entrada += $obj->entrada;
            $sub_saida += $obj->saida;
            $sub_apurado += $obj->apurado;
            $sub_despesas += $obj->despesas;
            $sub_saldo += $obj->saldo;
            $sub_comissao += $obj->comissao;
            $sub_pago += $obj->pago;
            // Totais
            $tot_entrada += $obj->entrada;
            $tot_saida += $obj->saida;
            $tot_apurado += $obj->apurado;
            $tot_despesas += $obj->despesas;
            $tot_saldo += $obj->saldo;
            $tot_comissao += $obj->comissao;
            $tot_pago += $obj->pago;
        }

        if($sub_entrada != 0 or $sub_despesas != 0 ){
            $obj = new StdClass;
            $obj->ponto = '*** TOTAL ***';
            $obj->dia = date('Y-m-d H:i:s');
            $obj->entrada = $sub_entrada;
            $obj->saida = $sub_saida;
            $obj->apurado = $sub_apurado;
            $obj->deve_ant = 0;
            $obj->despesas = $sub_despesas;
            $obj->saldo = $sub_saldo;
            $obj->comissao = $sub_comissao;
            $obj->pago = $sub_pago;
            $obj->cx_atu = 0;
            $obj->deve_atu = 0;
            $obj->usuario = $usuario->name;
            $row = $this->datagrid->addItem($obj);
            if($sub_despesas != 0){
                $row->popover = 'true';
                $row->popside = 'top';
                $row->popcontent = '<tr><th>Ponto</th><th>Descrição</th><th>Valor</th></tr>'.$conteudo.'</table>';
                $row->poptitle = 'Despesas';
                $conteudo = '';
            }
        }
        // Total Geral
        $obj = new StdClass;
        $obj->ponto = '*** GERAL ***';
        $obj->dia = date('Y-m-d H:i:s');
        $obj->entrada = $tot_entrada;
        $obj->saida = $tot_saida;
        $obj->apurado = $tot_apurado;
        $obj->deve_ant = 0;
        $obj->despesas = $tot_despesas;
        $obj->saldo = $tot_saldo;
        $obj->comissao = $tot_comissao;
        $obj->pago = $tot_pago;
        $obj->cx_atu = 0;
        $obj->deve_atu = 0;
        $obj->usuario = 'GERAL';
        $this->datagrid->addItem($obj);

        TTransaction::close();

    }

    function show()
    {
        $this->onReload( func_get_arg(0) );
        parent::show();
    }

}
