<?php
use Adianti\Widget\Wrapper\TDBCombo;

class Escolhe extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        // creates the items form and add a table inside
        $this->form_item = new TForm('form');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item->width = '100%';
        $this->form_item->add($table_item);

        $criteria = new TCriteria();
        $criteria->add(new TFilter('operador','=',TSession::getValue('userid')));

        $ponto_view = new TDBCombo('combo', 'jackpot', 'Ponto', 'id', 'nome', 'nome', $criteria);
        $acao = new TAction(array($this, 'onExitPonto'));
        $ponto_view->setChangeAction($acao);

        // add validators
        $ponto_view->addValidation('Ponto', new TRequiredValidator);

        // define some attributes
        $ponto_view->style = 'font-size: 17pt; height: 30px; text-align: center;';

        // add a row for the form title
        $row = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        $row->addCell(new TLabel('ESCOLHA O PONTO'))->style = 'text-align: center;';

        // create the field labels
        $lab_cli = new TLabel('PONTO');
        $lab_cli->setFontSize(17);
        $lab_cli->setFontFace('Trebuchet MS');

        $table_item->addRowSet($lab_cli)->style = 'text-align: center;';
        $table_item->addRowSet($ponto_view)->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($ponto_view));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item);
        parent::add($vbox);
    }

    public static function onExitPonto($param)
    {
        TSession::setValue('leituras', array());

        TTransaction::open('jackpot');

        $point = new Ponto($param['combo']);
        $porce = $point->porc_ponto;
        TSession::setValue('caixa_atual', $point->caixa);
        TSession::setValue('caixa_anterior', $point->caixa);
        TSession::setValue('deve_anterior', $point->deve);
        TSession::setValue('deve_atual', $point->deve);
        TSession::setValue('pago', 0);

        $repository = new TRepository('Maquina');
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_ponto', '=', $param['key']));
        $objects = $repository->load($criteria);
        if ($objects) {
            TSession::setValue('leituras', NULL);
            $leituras = array();
            foreach ($objects as $object) {
                $id = $object->id;
                $leituras[$id] = ['ent_ant' => 0,
                    'ent_atu' => 0,
                    'sai_ant' => 0,
                    'sai_atu' => 0,
                    'creditos' => 0,
                    'pagos' => 0,
                    'saldo' => 0,
                    'moeda' => 0,
                    'comissao' => $porce,
                    'entradas' => 0,
                    'saidas' => 0,
                    'apagar' => 0];
            }
            TSession::setValue('leituras', $leituras);
            $despesas = array();
            $despesas[0] = '';
            $despesas[1] = 0;
            $despesas[2] = '';
            $despesas[3] = 0;
            $despesas[4] = '';
            $despesas[5] = 0;
            TSession::setValue('despesas', $despesas);
        }
        TTransaction::close();
        TApplication::loadPage('LeituraForm', $param['key']);
    }
}
