<?php
/**
 * SystemPreferenceForm
 *
 * @version    7.6
 * @package    control
 * @subpackage admin
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class ConfigForm extends TStandardForm
{
    protected $form; // formulário

    /**
     * método construtor
     * Cria a página e o formulário de cadastro
     */
    function __construct()
    {
        parent::__construct();

        $this->setDatabase('bingo');
        $this->setActiveRecord('config');

        // cria o formulário
        $this->form = new BootstrapFormBuilder('form_config');
        $this->form->setFormTitle('Configuração');

        // cria os campos do formulário
        $titulo          = new TEntry('titulo');
        $equips          = new TEntry('equips');
        $txcard1         = new TEntry('txcard1');
        $txcard2         = new TEntry('txcard2');
        $txcard3         = new TEntry('txcard3');
        $txcard4         = new TEntry('txcard4');
        $semana          = new TCombo('semana');
        $socios          = new TEntry('socios');
        $passacaixa      = new TCombo('passacaixa');
        $valesclientes   = new TCombo('valesclientes');
        $contasatendente = new TCombo('contasatendente');
        $limitepagamento = new TEntry('LimitePagamento');
        $pagamento       = new TDateTime('pagamento');

        $yesno = array();
        $yesno['1'] = _t('Yes');
        $yesno['0'] = _t('No');
        $passacaixa->addItems($yesno);
        $valesclientes->addItems($yesno);
        $contasatendente->addItems($yesno);

        $dias_semana = array(0=>'Domingo',1=>'Segunda',2=>'Terça',3=>'Quarta',4=>'Quinta',5=>'Sexta',6=>'Sábado');
        $semana->addItems($dias_semana);

        $this->form->addFields( [new TLabel('Título')], [$titulo] );
        $this->form->addFields( [new TLabel('Equipamentos')], [$equips] );
        $this->form->addFields( [new TLabel('Taxa Cartão 1')], [$txcard1] );
        $this->form->addFields( [new TLabel('Taxa Cartão 2')], [$txcard2] );
        $this->form->addFields( [new TLabel('Taxa Cartão 3')], [$txcard3] );
        $this->form->addFields( [new TLabel('Taxa Cartão 4')], [$txcard4] );
        $this->form->addFields( [new TLabel('Início da Semana')], [$semana] );
        $this->form->addFields( [new TLabel('Qtde Sócios')], [$socios] );
        $this->form->addFields( [new TLabel('Usa Passa Caixa')], [$passacaixa] );
        $this->form->addFields( [new TLabel('Usa Vales Clientes')], [$valesclientes] );
        $this->form->addFields( [new TLabel('Mostra Conta Atendentes')], [$contasatendente] );
        $this->form->addFields( [new TLabel('LImite de Pagamento')], [$limitepagamento] );
        $this->form->addFields( [new TLabel('Vencimento Mensalidade')], [$pagamento] );

        $titulo->setSize('70%');
        $equips->setSize('70%');
        $txcard1->setSize('70%');
        $txcard2->setSize('70%');
        $txcard3->setSize('70%');
        $txcard4->setSize('70%');
        $semana->setSize('70%');
        $socios->setSize('70%');
        $passacaixa->setSize('70%');
        $valesclientes->setSize('70%');
        $contasatendente->setSize('70%');
        $limitepagamento->setSize('70%');
        $pagamento->setSize('70%');


        $btn = $this->form->addAction(_t('Save'), new TAction(array($this, 'onSave')), 'far:save');
        $btn->class = 'btn btn-sm btn-primary';

        $container = new TVBox;
        $container->{'style'} = 'width: 100%;';
        $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        parent::add($container);
    }

    /**
     * Carrega o formulário de preferências
     */
    function onEdit($param)
    {
        try
        {
            // open a transaction with database
            TTransaction::open($this->database);

            $preferences = config::getAllConfigs();
            if ($preferences)
            {
                $this->form->setData((object) $preferences);
            }

            // close the transaction
            TTransaction::close();
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * method onSave()
     * Executed whenever the user clicks at the save button
     */
    function onSave()
    {
        try
        {
            // open a transaction with database
            TTransaction::open($this->database);

            // get the form data
            $data = $this->form->getData();
            $data_array = (array) $data;

            foreach ($data_array as $property => $value)
            {
                $object = new config;
                $object->{'id'}    = $property;
                $object->{'value'} = $value;
                $object->store();
            }

            // fill the form with the active record data
            $this->form->setData($data);

            // close the transaction
            TTransaction::close();

            // shows the success message
            TToast::show('success', 'Configurações Atualizadas', 'top right', 'far:check-circle' );
            // reload the listing
        }
        catch (Exception $e) // in case of exception
        {
            // get the form data
            $object = $this->form->getData($this->activeRecord);

            // fill the form with the active record data
            $this->form->setData($object);

            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }
}
