<?php
/**
 * StandardFormDataGridView
 *
 * @version    1.0
 * @package    samples
 * @subpackage tutor
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006-2014 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    http://www.adianti.com.br/framework-license
 */
class CobradorList extends TStandardFormList
{
    protected $form;      // formulário de cadastro
    protected $datagrid;  // listagem
    protected $loaded;
    protected $pageNavigation;  // pagination component

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();

        // define the database
        parent::setDatabase('jackpot');

        // define the Active Record
        parent::setActiveRecord('Cobrador');

        // define the default order
        parent::setDefaultOrder('id', 'asc');

        // turn off limit for datagrid
        $this->setLimit(10);

        // create the form
        $this->form = new TQuickForm('form_cobradores');
        $this->form->class = 'tform'; // CSS class
        $this->form->setFormTitle('Cadastro de Cobradores');

        // create the form fields
        $id          = new THidden('id');
        $nome        = new TEntry('nome');
        $gerente_id  = new TDBCombo('id_gerente', 'jackpot', 'gerente', 'id', 'nome');

        $nome->addValidation(_t('Name'), new TRequiredValidator);
        $gerente_id->addValidation('Gerente', new TRequiredValidator);

        // add the form fields
        $this->form->addQuickField('ID',      $id,          40);
        $this->form->addQuickField('Nome',    $nome,       100);
        $this->form->addQuickField('Gerente', $gerente_id, 100);

        // define the form actions
        $this->form->addQuickAction(_t('Save'), new TAction(array($this, 'onSave')), 'ico_save.png');
        $this->form->addQuickAction(_t('New'),  new TAction(array($this, 'onClear')), 'ico_new.png');

        // make id not editable
        $id->setEditable(FALSE);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        // add the columns
        $this->datagrid->addQuickColumn('Nome',    'nome',         'left',  150, new TAction(array($this, 'onReload')), array('order', 'nome'));
        $this->datagrid->addQuickColumn('Gerente', 'nome_gerente' ,'left',  150, new TAction(array($this, 'onReload')), array('order', 'nome_gerente'));

        // add the actions
        $this->datagrid->addQuickAction('Edit',  new TDataGridAction(array($this, 'onEdit')),   'id', 'ico_edit.png');
        $this->datagrid->addQuickAction('Delete', new TDataGridAction(array($this, 'onDelete')), 'id', 'ico_delete.png');

        // create the datagrid model
        $this->datagrid->createModel();

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        // wrap objects inside a table
        $vbox = new TVBox;
        $vbox->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $vbox->add($this->form);
        $vbox->add($this->datagrid);
        $vbox->add($this->pageNavigation);

        // pack the table inside the page
        parent::add($vbox);
    }
}