<?php
/**
 * StandardFormDataGridView
 *
 * @version    1.0
 * @package    samples
 * @subpackage tutor
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006-2014 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    http://www.adianti.com.br/framework-license
 */
class ClienteList extends TStandardFormList
{
    protected $form;      // formulário de cadastro
    protected $datagrid;  // listagem
    protected $loaded;
    protected $pageNavigation;  // pagination component

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();

        // define the database
        parent::setDatabase('jackpot');

        // define the Active Record
        parent::setActiveRecord('Cliente');

        // define the default order
        parent::setDefaultOrder('id', 'asc');

        // turn off limit for datagrid
        $this->setLimit(10);

        // create the form
        $this->form = new TQuickForm('form_clientes');
        $this->form->class = 'tform'; // CSS class
        $this->form->setFormTitle('Cadastro de Clientes');

        // create the form fields
        $id        = new THidden('id');
        $estabe_id = new TDBCombo('id_estabelecimento', 'jackpot', 'estabelecimento', 'id', 'descricao', 'descricao');
        $zona_id   = new TDBCombo('id_zona', 'jackpot', 'zona', 'id', 'descricao', 'descricao');
        $nome      = new TEntry('nome');
        $endereco  = new TEntry('endereco');
        $bairro    = new TEntry('bairro');
        $cidade    = new TEntry('cidade');
        $estado    = new TEntry('estado');
        $telefone  = new TEntry('telefone');

        $nome->addValidation(_t('Name'), new TRequiredValidator);
        $estabe_id->addValidation('Tipo de Estabelecimento', new TRequiredValidator);
        $zona_id->addValidation('Zona', new TRequiredValidator);
        $nome->addValidation('Nome', new TRequiredValidator);
        $endereco->addValidation('Endereço', new TRequiredValidator);
        $bairro->addValidation('Bairro', new TRequiredValidator);
        $cidade->addValidation('Cidade', new TRequiredValidator);
        $estado->addValidation('Estado', new TRequiredValidator);
        $telefone->addValidation('Telefone', new TRequiredValidator);

        // add the form fields
        $this->form->addQuickField('ID',              $id,         40);
        $this->form->addQuickField('Estabelecimento', $estabe_id, 200);
        $this->form->addQuickField('Zona',            $zona_id,   200);
        $this->form->addQuickField('Nome',            $nome,      400);
        $this->form->addQuickField('Endereço',        $endereco,  400);
        $this->form->addQuickField('Bairro',          $bairro,    200);
        $this->form->addQuickField('Cidade',          $cidade,    200);
        $this->form->addQuickField('Estado',          $estado,    50);
        $this->form->addQuickField('Telefone',        $telefone,  200);

        // define the form actions
        $this->form->addQuickAction(_t('Save'), new TAction(array($this, 'onSave')), 'ico_save.png');
        $this->form->addQuickAction(_t('New'),  new TAction(array($this, 'onClear')), 'ico_new.png');

        // make id not editable
        $id->setEditable(FALSE);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        // add the columns
        $this->datagrid->addQuickColumn('Tipo',     'nome_estabelecimento', 'left',  100, new TAction(array($this, 'onReload')), array('order', 'nome_estabelecimento'));
        $this->datagrid->addQuickColumn('Zona',     'nome_zona' ,           'left',  150, new TAction(array($this, 'onReload')), array('order', 'nome_zona'));
        $this->datagrid->addQuickColumn('Nome',     'nome',                 'left',  150, new TAction(array($this, 'onReload')), array('order', 'nome'));
        $this->datagrid->addQuickColumn('Endereço', 'endereco',             'left',  300, new TAction(array($this, 'onReload')), array('order', 'endereco'));
        $this->datagrid->addQuickColumn('Bairro',   'bairro',               'left',  150, new TAction(array($this, 'onReload')), array('order', 'bairro'));
        $this->datagrid->addQuickColumn('Cidade',   'cidade',               'left',  150, new TAction(array($this, 'onReload')), array('order', 'cidade'));
        $this->datagrid->addQuickColumn('Estado',   'estado',               'left',   50, new TAction(array($this, 'onReload')), array('order', 'estado'));
        $this->datagrid->addQuickColumn('Telefone', 'telefone',             'left',  150, new TAction(array($this, 'onReload')), array('order', 'telefone'));

        // add the actions
        $this->datagrid->addQuickAction('Edit',  new TDataGridAction(array($this, 'onEdit')),   'id', 'ico_edit.png');
        $this->datagrid->addQuickAction('Delete', new TDataGridAction(array($this, 'onDelete')), 'id', 'ico_delete.png');

        // create the datagrid model
        $this->datagrid->createModel();

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        // wrap objects inside a table
        $vbox = new TVBox;
        $vbox->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $vbox->add($this->form);
        $vbox->add($this->datagrid);
        $vbox->add($this->pageNavigation);

        // pack the table inside the page
        parent::add($vbox);
    }
}