<?php

class CaixaFecPrint extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->primeirodia = $param["dia"];

        // create the datagrid - Contadores
        $this->frame10 = new TFrame;
        $this->datagrid0 = new TQuickGrid;
        $this->datagrid0->style = 'width: 100%';
        $this->datagrid0->addQuickColumn('MÁQUINAS'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid0->addQuickColumn('LEITURA','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $manual = $this->datagrid0->addQuickColumn('MANUAL'    ,'manual'    ,'center', 150);
        $manual->setTransformer(array($this, 'formatsaldo'));
        $diferenca = $this->datagrid0->addQuickColumn('DIFERENÇA' ,'diferenca' ,'center', 150);
        $diferenca->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->createModel();
        $this->frame10->add($this->datagrid0);

        // create the datagrid - Receitas
        $this->frame11 = new TFrame;
        $this->datagrid1 = new TQuickGrid;
        $this->datagrid1->style = 'width: 100%';
        $this->datagrid1->addQuickColumn('RECEITA'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid1->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid1->createModel();
        $this->frame11->add($this->datagrid1);

        // create the datagrid - Entrega do caixa
        $this->frame12 = new TFrame;
        $this->datagrid2 = new TQuickGrid;
        $this->datagrid2->style = 'width: 100%';
        $this->datagrid2->addQuickColumn('CAIXA A ENTREGAR'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid2->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid2->createModel();
        $this->frame12->add($this->datagrid2);

        // create the datagrid - Despesas
        $this->frame13 = new TFrame;
        $this->datagrid3 = new TQuickGrid;
        $this->datagrid3->style = 'width: 100%';
        $this->datagrid3->addQuickColumn('DESPESAS'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid3->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid3->createModel();
        $this->frame13->add($this->datagrid3);

        // create the datagrid - Vales
        $this->frame15 = new TFrame;
        $this->datagrid5 = new TQuickGrid;
        $this->datagrid5->style = 'width: 100%';
        $this->datagrid5->addQuickColumn('VALES'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid5->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid5->createModel();
        $this->frame15->add($this->datagrid5);

        // creates a frame
        $this->frame = new TFrame;
        $this->frame1 = new TFrame;

        $this->onReload();

        // converts the HTML template into PDF
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($this->frame->getContents().$this->frame10->getContents().$this->frame11->getContents().$this->frame12->getContents().$this->frame15->getContents().$this->frame13->getContents().$this->frame1->getContents());
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // write and open file
        file_put_contents('app/output/document.pdf', $dompdf->output());

        // open window to show pdf
        $window = TWindow::create('Caixa do Dia', 0.8, 0.8);
        $object = new TElement('object');
        $object->data  = 'app/output/document.pdf';
        $object->type  = 'application/pdf';
        $object->style = "width: 100%; height:calc(100% - 10px)";
        $window->add($object);
        $window->show();


        TApplication::loadPage('CaixaFecList', $this->primeirodia);

    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload($param = NULL)
    {
        try
        {
            $ini = parse_ini_file('app/config/application.ini', true);

            TTransaction::open('bingo');

            /*            // Soma Clientes
                        $repository = new TRepository('cliente');
                        $clientes = $repository->load();
                        $saldo_clientes = 0;
                        foreach ($clientes as $cliente){
                            $saldo_clientes += $cliente->saldo;
                        } */
            // Recupera Contadores
            $repository = new TRepository('leitura');
            $criteria = new TCriteria;
            $criteria->add(new TFilter('fechado', '=', $this->primeirodia));
            $reads = $repository->load($criteria);
            $conta_entra = 0;
            $conta_saida = 0;
            foreach ($reads as $read){
                $conta_entra += (float)(($read->fim_entra - $read->ini_entra) * $read->credito);
                $conta_saida += (float)(($read->fim_sai   - $read->ini_sai)   * $read->credito);
            }
            // Recupera Lançamentos
            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $criteria->setProperty('order', 'maquina asc, descricao asc, fechado asc');
            $criteria->add(new TFilter('fechado', '=', $this->primeirodia));
            $customers = $repository->load($criteria);

            $this->datagrid0->clear();
            $this->datagrid1->clear();
            $this->datagrid2->clear();
            $this->datagrid3->clear();
            $this->datagrid5->clear();

            $sangria=0;
            $pagamentos=0;
            $inicial=0;
            $reforco=0;
            $aporte=0;
            $pagos=0;
            $dinheiro=0;
            $retirada=0;
            $cartao1=0;
            $cartao2=0;
            $cheque=0;
            $dolar=0;
            $despesas=0;
            $vales=0;
            $conta=1;
            $a_reforco=array();
            $a_aporte=array();
            $a_vales=array();
            $a_retiradas=array();
            $saldo_vales = 0;
            if ($customers) {
                foreach ($customers as $customer) {
                    if ($customer->maquina < 100) {
                        $pagamentos += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 101) {
                        $inicial += $customer->valor;
                    } elseif ($customer->maquina == 102) {
                        $a_reforco[$conta] = new stdclass();
                        $a_reforco[$conta]->maquinas = $customer->descricao;
                        $a_reforco[$conta]->contadores = $customer->valor;
                        $conta++;
                        $reforco += $customer->valor;
                        /*                    } elseif ($customer->maquina == 103) {
                                                $a_vales[$conta] = new stdclass();
                                                $a_vales[$conta]->maquinas = $customer->descricao;
                                                $a_vales[$conta]->contadores = $customer->valor;
                                                $conta++;
                                                $pagos += $customer->valor; */
                    } elseif ($customer->maquina == 104) {
                        $sangria += $customer->valor;
                    } elseif ($customer->maquina == 120) {
                        $a_aporte[$conta] = new stdclass();
                        $a_aporte[$conta]->maquinas = $customer->descricao;
                        $a_aporte[$conta]->contadores = $customer->valor;
                        $conta++;
                        $aporte += $customer->valor;
                    } elseif ($customer->maquina == 150) {
                        $a_retiradas[$conta] = new stdclass();
                        $a_retiradas[$conta]->maquinas = $customer->descricao;
                        $a_retiradas[$conta]->contadores = $customer->valor;
                        $conta++;
                        $retirada -= $customer->valor;
                    } elseif ($customer->maquina == 151) {
                        $cartao1 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 152) {
                        $cartao2 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 153) {
                        $cheque += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 500) {
                        $saldo_vales += ($customer->valor);
                    } elseif ($customer->maquina == 158 or $customer->maquina == 103) {
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid5->addItem($obj);
                        $vales += $customer->valor;
                    } elseif ($customer->maquina < 400){
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid3->addItem($obj);
                        $despesas += $customer->valor;
                    }
                    if ($customer->maquina < 400) {
                        $dinheiro += $customer->valor;
                    }
                }
            }

            $saldo_clientes = $saldo_vales + ($vales * -1);

            $geral = $inicial+$reforco+$aporte+($conta_entra - $conta_saida)+$saldo_vales;

            $obj = new stdclass();
            $obj->maquinas   = 'ENTRADAS';
            $obj->contadores = $conta_entra;
            $obj->manual     = $sangria;
            $obj->diferenca  = $sangria - $conta_entra;
            $this->datagrid0->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'PAGAMENTOS';
            $obj->contadores = $conta_saida;
            $obj->manual     = $pagamentos;
            $obj->diferenca  = $conta_saida - $pagamentos;
            $this->datagrid0->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO';
            $obj->contadores = $conta_entra - $conta_saida;
            $obj->manual     = $sangria - $pagamentos;
            $obj->diferenca  = ($sangria - $pagamentos) - ($conta_entra - $conta_saida);
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'CAIXA INICIAL';
            $obj->contadores = $inicial;
            $this->datagrid1->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO DE VALES ANTERIOR';
            $obj->contadores = $saldo_vales;
            $this->datagrid1->addItem($obj);
            if($reforco != 0) {
                foreach ($a_reforco as $key =>$item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_reforco[$key]->maquinas;
                    $obj->contadores = $a_reforco[$key]->contadores;
                    $this->datagrid1->addItem($obj);
                }
            }
            if($aporte != 0) {
                foreach ($a_aporte as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_aporte[$key]->maquinas;
                    $obj->contadores = $a_aporte[$key]->contadores;
                    $this->datagrid1->addItem($obj);
                }
            }
            /*            if($pagos != 0) {
                            foreach ($a_vales as $key => $item){
                                $obj = new stdclass();
                                $obj->maquinas = $a_vales[$key]->maquinas;
                                $obj->contadores = $a_vales[$key]->contadores;
                                $this->datagrid1->addItem($obj);
                            }
                        } */
            $obj = new stdclass();
            $obj->maquinas = 'SALDO MÁQUINAS';
            $obj->contadores = $conta_entra - $conta_saida;
            $this->datagrid1->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL';
            $obj->contadores = $geral;
            $this->datagrid1->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'DINHEIRO';
            $obj->contadores = $dinheiro;
            $this->datagrid2->addItem($obj);
            if($cartao1 != 0) {
                $obj = new stdclass();
                $obj->maquinas = 'CARTÃO CIELO';
                $obj->contadores = $cartao1;
                $this->datagrid2->addItem($obj);
            }
            if($cartao2 != 0) {
                $obj = new stdclass();
                $obj->maquinas = 'CARTÃO GETNET';
                $obj->contadores = $cartao2;
                $this->datagrid2->addItem($obj);
            }
            if($cheque != 0) {
                $obj = new stdclass();
                $obj->maquinas = 'CHEQUE';
                $obj->contadores = $cheque;
                $this->datagrid2->addItem($obj);
            }
            if($dolar != 0) {
                $obj = new stdclass();
                $obj->maquinas = 'MOEDA ESTRANGEIRA';
                $obj->contadores = $dolar;
                $this->datagrid2->addItem($obj);
            }
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO DE VALES ATUAL';
            $obj->contadores = $saldo_clientes;
            $this->datagrid2->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'DESPESAS';
            $obj->contadores = $despesas*-1;
            $this->datagrid2->addItem($obj);

            if($retirada != 0) {
                foreach ($a_retiradas as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_retiradas[$key]->maquinas;
                    $obj->contadores = ($a_retiradas[$key]->contadores) * -1;
                    $this->datagrid2->addItem($obj);
                }
            }

            $obj = new stdclass();
            $situacao = (($despesas * -1) +$dinheiro+$cartao1+$cartao2+$cheque+$dolar) - $geral + $retirada + $saldo_clientes  ;
            if($situacao < 0){$obj->maquinas = 'FALTA DAS MÁQUINAS';}else{$obj->maquinas = 'SOBRA DAS MÁQUINAS';}
            $obj->contadores = $situacao * -1;
            $this->datagrid2->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $dinheiro+$cartao1+$cartao2+$cheque+$dolar+$saldo_clientes-$despesas+$retirada-$situacao;
            $this->datagrid2->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $vales;
            $this->datagrid5->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $despesas;
            $this->datagrid3->addItem($obj);

            $azul=$dinheiro;
            $label = 'DINHEIRO('.number_format($dinheiro, 2, ',', '.').')';
            $taxa=0;
            If($cartao1+$cartao2 != 0){
                $label = $label.' + CARTÃO('.number_format($cartao1+$cartao2, 2, ',', '.').') ';
                if($ini['general']['txcard1'] != 0 and $cartao1 != 0){
                    $taxa += $cartao1 * ($ini['general']['txcard1']/100);
                }
                if($ini['general']['txcard2'] != 0 and $cartao2 != 0){
                    $taxa += $cartao2 * ($ini['general']['txcard2']/100);
                }
                if($taxa != 0){
                    $label = $label.'- TAXA CARTÃO '.'('.number_format($taxa, 2, ',', '.').')';
                }
                $azul += $cartao1 + $cartao2 - $taxa;
            }
            If($cheque != 0){$label = $label.' + CHEQUE('.number_format($cheque, 2, ',', '.').')';$azul += $cheque;}
            If($dolar != 0){$label = $label.' + MOEDA ESTRANGEIRA('.number_format($dolar, 2, ',', '.').')';$azul += $dolar;}
            If($retirada != 0){$label = $label.' + RETIRADAS('.number_format($retirada, 2, ',', '.').')';$azul += $retirada;}
            $label = $label.' - CAIXA INICIAL('.number_format($inicial, 2, ',', '.').')';
            $azul -= $inicial;
            If($reforco != 0){$label = $label.' - REFORÇO('.number_format($reforco, 2, ',', '.').')';$azul -= $reforco;}
            If($aporte != 0){$label = $label.' - APORTE('.number_format($aporte, 2, ',', '.').')';$azul -= $aporte;}
            $label = $label.' = ';
            $label1 = new TLabel('');
            $label1->setValue(number_format($azul, 2, ',', '.'));
            if($azul < 0){$label1->style = "color:red";}else{$label1->style = "color:blue";}

            $lab_cxdia = new TLabel('dia');
            $lab_cxdia->setFontSize(17);
            $lab_cxdia->setFontFace('Trebuchet MS');
            $lab_cxdia->setValue('CAIXA DO DIA - ');
            $this->frame->add($lab_cxdia);

            $lab_dia = new TLabel('dia');
            $lab_dia->setFontSize(17);
            $lab_dia->setFontFace('Trebuchet MS');
            $form_dia = substr($this->primeirodia,8,2).'/'.substr($this->primeirodia,5,2).'/'.substr($this->primeirodia,0,4).' - '.substr($this->primeirodia,11,2).':'.substr($this->primeirodia,14,2).':'.substr($this->primeirodia,17,2);
            $lab_dia->setValue($form_dia);
            $this->frame->add($lab_dia);

            $this->frame1->add(new TLabel($label));
            $this->frame1->add($label1);

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
            $this->CxInicial = $dinheiro;

        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        return "<span>$number</span>";
    }
}