<?php
class CaixaDiaPrint extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        $this->CxInicial = 0;
        $this->VlInicial = 0;

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        TTransaction::open('bingo');

        // Soma Clientes
        $repository = new TRepository('cliente');
        $clientes = $repository->load();
        $saldo_clientes = 0;
        foreach ($clientes as $cliente){
            $saldo_clientes += $cliente->saldo;
        }
        // Recupera Lançamentos
        $repository = new TRepository('movimento');
        $criteria = new TCriteria;
        $criteria->setProperty('order', 'maquina asc, descricao asc, fechado asc');
        $criteria->add(new TFilter('fechado', 'IS', NULL));
        $customers = $repository->load($criteria);

        // Recupera Contadores
        $repository = new TRepository('leitura');
        $criteria = new TCriteria;
        $criteria->add(new TFilter('fechado', 'IS', NULL));
        $reads = $repository->load($criteria);
        $conta_entra = 0;
        $conta_saida = 0;
        foreach ($reads as $read){
            $conta_entra += (float)(($read->fim_entra - $read->ini_entra) * $read->credito);
            $conta_saida += (float)(($read->fim_sai   - $read->ini_sai)   * $read->credito);
        }

        // close the transaction
        TTransaction::close();

        // create the datagrid - Vales
        $this->frame3 = new TFrame;
        $this->datagrid3 = new TDataGrid;
        $this->datagrid3->style = 'width: 100%';
        $this->datagrid3->addColumn(new TDataGridColumn('maquinas',    'VALES',    'left', '50%'));
        $contadores = new TDataGridColumn('contadores',  'VALOR', 'center', '50%');
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid3->addColumn($contadores);
        $this->datagrid3->createModel();
        $this->frame3->add($this->datagrid3);

        // create the datagrid - Despesas
        $this->frame4 = new TFrame;
        $this->datagrid4 = new TDataGrid;
        $this->datagrid4->style = 'width: 100%';
        $this->datagrid4->addColumn(new TDataGridColumn('maquinas',    'DESPESAS',    'left', '50%'));
        $contadores = new TDataGridColumn('contadores',  'VALOR', 'center', '50%');
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid4->addColumn($contadores);
        $this->datagrid4->createModel();
        $this->frame4->add($this->datagrid4);

        $sangria=0;
        $pagamentos=0;
        $inicial=0;
        $reforco=0;
        $aporte=0;
        $dinheiro=0;
        $retirada=0;
        $cartao1=0;
        $cartao2=0;
        $cheque=0;
        $despesas=0;
        $vales=0;
        $conta=1;
        $a_reforco=array();
        $a_aporte=array();
        $a_retiradas=array();
        $saldo_vales = 0;
        if ($customers) {
            foreach ($customers as $customer) {
                if ($customer->maquina < 100) {
                    $pagamentos += ($customer->valor) * -1;
                } elseif ($customer->maquina == 101) {
                    $inicial += $customer->valor;
                } elseif ($customer->maquina == 102) {
                    $a_reforco[$conta] = new stdclass();
                    $a_reforco[$conta]->maquinas = $customer->descricao;
                    $a_reforco[$conta]->contadores = $customer->valor;
                    $conta++;
                    $reforco += $customer->valor;
                } elseif ($customer->maquina == 104) {
                    $sangria += $customer->valor;
                } elseif ($customer->maquina == 120) {
                    $a_aporte[$conta] = new stdclass();
                    $a_aporte[$conta]->maquinas = $customer->descricao;
                    $a_aporte[$conta]->contadores = $customer->valor;
                    $conta++;
                    $aporte += $customer->valor;
                } elseif ($customer->maquina == 150) {
                    $a_retiradas[$conta] = new stdclass();
                    $a_retiradas[$conta]->maquinas = $customer->descricao;
                    $a_retiradas[$conta]->contadores = $customer->valor;
                    $conta++;
                    $retirada -= $customer->valor;
                } elseif ($customer->maquina == 151) {
                    $cartao1 += ($customer->valor) * -1;
                } elseif ($customer->maquina == 152) {
                    $cartao2 += ($customer->valor) * -1;
                } elseif ($customer->maquina == 153) {
                    $cheque += ($customer->valor) * -1;
                } elseif ($customer->maquina == 500) {
                    $saldo_vales += ($customer->valor);
                } elseif ($customer->maquina == 158 or $customer->maquina == 103) {
                    $obj = new stdclass();
                    $obj->maquinas = $customer->descricao;
                    $obj->contadores = $customer->valor;
                    $this->datagrid3->addItem($obj);
                    $vales += $customer->valor;
                } elseif ($customer->maquina < 400){
                    $obj = new stdclass();
                    $obj->maquinas = $customer->descricao;
                    $obj->contadores = $customer->valor;
                    $this->datagrid4->addItem($obj);
                    $despesas += $customer->valor;
                }
                if ($customer->maquina < 400) {
                    $dinheiro += $customer->valor;
                }
            }
        }
        $geral = $inicial+$reforco+$aporte+($conta_entra - $conta_saida)+$saldo_vales;

        $this->frame0 = new TFrame;
        // create the datagrid - Contadores
        $this->datagrid0 = new TDataGrid;
        $this->datagrid0->style = 'width: 100%';
        $this->datagrid0->addColumn(new TDataGridColumn('maquinas',    'MÁQUINAS',    'left', '25%'));
        $contadores = new TDataGridColumn('contadores',  'LEITURA', 'center', '25%');
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->addColumn($contadores);
        $manual = new TDataGridColumn('manual',  'MANUAL', 'center', '25%');
        $manual->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->addColumn($manual);
        $diferenca = new TDataGridColumn('diferenca',  'DIFERENÇA', 'center', '25%');
        $diferenca->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->addColumn($diferenca);
        $this->datagrid0->createModel();
        $this->frame0->add($this->datagrid0);

        $obj = new stdclass();
        $obj->maquinas   = 'ENTRADAS';
        $obj->contadores = $conta_entra;
        $obj->manual     = $sangria;
        $obj->diferenca  = $sangria - $conta_entra;
        $this->datagrid0->addItem($obj);
        $obj = new stdclass();
        $obj->maquinas   = 'PAGAMENTOS';
        $obj->contadores = $conta_saida;
        $obj->manual     = $pagamentos;
        $obj->diferenca  = $conta_saida - $pagamentos;
        $this->datagrid0->addItem($obj);
        $obj = new stdclass();
        $obj->maquinas   = 'SALDO';
        $obj->contadores = $conta_entra - $conta_saida;
        $obj->manual     = $sangria - $pagamentos;
        $obj->diferenca  = ($sangria - $pagamentos) - ($conta_entra - $conta_saida);
        $this->datagrid0->addItem($obj);


        $this->frame1 = new TFrame;
        // create the datagrid - Receitas
        $this->datagrid1 = new TDataGrid;
        $this->datagrid1->style = 'width: 100%';
        $this->datagrid1->addColumn(new TDataGridColumn('maquinas',    'RECEITA',    'left', '50%'));
        $contadores = new TDataGridColumn('contadores',  'VALOR', 'center', '50%');
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid1->addColumn($contadores);
        $this->datagrid1->createModel();
        $this->frame1->add($this->datagrid1);

        $obj = new stdclass();
        $obj->maquinas   = 'CAIXA INICIAL';
        $obj->contadores = $inicial;
        $this->datagrid1->addItem($obj);
        $obj = new stdclass();
        $obj->maquinas   = 'SALDO DE VALES ANTERIOR';
        $obj->contadores = $saldo_vales;
        $this->datagrid1->addItem($obj);
        if($reforco != 0) {
            foreach ($a_reforco as $key =>$item){
                $obj = new stdclass();
                $obj->maquinas = $a_reforco[$key]->maquinas;
                $obj->contadores = $a_reforco[$key]->contadores;
                $this->datagrid1->addItem($obj);
            }
        }
        if($aporte != 0) {
            foreach ($a_aporte as $key => $item){
                $obj = new stdclass();
                $obj->maquinas = $a_aporte[$key]->maquinas;
                $obj->contadores = $a_aporte[$key]->contadores;
                $this->datagrid1->addItem($obj);
            }
        }
        $obj = new stdclass();
        $obj->maquinas = 'SALDO MÁQUINAS';
        $obj->contadores = $conta_entra - $conta_saida;
        $this->datagrid1->addItem($obj);
        $obj = new stdclass();
        $obj->maquinas   = 'TOTAL';
        $obj->contadores = $geral;
        $this->datagrid1->addItem($obj);


        // create the datagrid - Entrega do caixa
        $this->frame2 = new TFrame;
        $this->datagrid2 = new TDataGrid;
        $this->datagrid2->style = 'width: 100%';
        $this->datagrid2->addColumn(new TDataGridColumn('maquinas',    'CAIXA A ENTREGAR',    'left', '50%'));
        $contadores = new TDataGridColumn('contadores',  'VALOR', 'center', '50%');
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid2->addColumn($contadores);
        $this->datagrid2->createModel();
        $this->frame2->add($this->datagrid2);

        $obj = new stdclass();
        $obj->maquinas   = 'DINHEIRO';
        $obj->contadores = $dinheiro;
        $this->datagrid2->addItem($obj);
        if($cartao1 != 0) {
            $obj = new stdclass();
            $obj->maquinas = 'CARTÃO CIELO';
            $obj->contadores = $cartao1;
            $this->datagrid2->addItem($obj);
        }
        if($cartao2 != 0) {
            $obj = new stdclass();
            $obj->maquinas = 'CARTÃO GETNET';
            $obj->contadores = $cartao2;
            $this->datagrid2->addItem($obj);
        }
        if($cheque != 0) {
            $obj = new stdclass();
            $obj->maquinas = 'CHEQUE';
            $obj->contadores = $cheque;
            $this->datagrid2->addItem($obj);
        }
        $obj = new stdclass();
        $obj->maquinas   = 'SALDO DE VALES ATUAL';
        $obj->contadores = $saldo_clientes;
        $this->datagrid2->addItem($obj);

        $obj = new stdclass();
        $obj->maquinas = 'DESPESAS';
        $obj->contadores = $despesas*-1;
        $this->datagrid2->addItem($obj);

        if($retirada != 0) {
            foreach ($a_retiradas as $key => $item){
                $obj = new stdclass();
                $obj->maquinas = $a_retiradas[$key]->maquinas;
                $obj->contadores = $a_retiradas[$key]->contadores * -1;
                $this->datagrid2->addItem($obj);
            }
        }

        $obj = new stdclass();
        $situacao = (($despesas * -1) +$dinheiro+$cartao1+$cartao2+$cheque) - $geral + $retirada + $saldo_clientes  ;
        if($situacao < 0){$obj->maquinas = 'FALTA DAS MÁQUINAS';}else{$obj->maquinas = 'SOBRA DAS MÁQUINAS';}
        $obj->contadores = $situacao * -1;
        $this->datagrid2->addItem($obj);

        $obj = new stdclass();
        $obj->maquinas = 'TOTAL';
        $obj->contadores = $dinheiro+$cartao1+$cartao2+$cheque+$saldo_clientes-$despesas+$retirada-$situacao;
        $this->datagrid2->addItem($obj);

        $obj = new stdclass();
        $obj->maquinas = 'TOTAL';
        $obj->contadores = $vales;
        $this->datagrid3->addItem($obj);

        $obj = new stdclass();
        $obj->maquinas = 'TOTAL';
        $obj->contadores = $despesas;
        $this->datagrid4->addItem($obj);

        // creates a frame
        $this->frame5 = new TFrame;
        $ini = parse_ini_file('app/config/application.ini', true);
        $azul=$dinheiro;
        $label = 'DINHEIRO('.number_format($dinheiro, 2, ',', '.').')';
        $taxa=0;
        If($cartao1+$cartao2 != 0){
            $label = $label.' + CARTÃO('.number_format($cartao1+$cartao2, 2, ',', '.').') ';
            if($ini['general']['txcard1'] != 0 and $cartao1 != 0){
                $taxa += $cartao1 * ($ini['general']['txcard1']/100);
            }
            if($ini['general']['txcard2'] != 0 and $cartao2 != 0){
                $taxa += $cartao2 * ($ini['general']['txcard2']/100);
            }
            if($taxa != 0){
                $label = $label.'- TAXA CARTÃO '.'('.number_format($taxa, 2, ',', '.').')';
            }
            $azul += $cartao1 + $cartao2 - $taxa;
        }
        If($cheque != 0){$label = $label.' + CHEQUE('.number_format($cheque, 2, ',', '.').')';$azul += $cheque;}
        If($retirada != 0){$label = $label.' + RETIRADAS('.number_format($retirada, 2, ',', '.').')';$azul += $retirada;}
        $label = $label.' - CAIXA INICIAL('.number_format($inicial, 2, ',', '.').')';
        $azul -= $inicial;
        If($reforco != 0){$label = $label.' - REFORÇO('.number_format($reforco, 2, ',', '.').')';$azul -= $reforco;}
        If($aporte != 0){$label = $label.' - APORTE('.number_format($aporte, 2, ',', '.').')';$azul -= $aporte;}
        $label = $label.' = ';
        $label1 = new TLabel('');
        $label1->setValue(number_format($azul, 2, ',', '.'));

        $this->frame5->add(new TLabel($label));
        $this->frame5->add($label1);

        TApplication::loadPage('CaixaDiaList');

    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        return "<span>$number</span>";
    }

    public function onPrint()
    {
        // converts the HTML template into PDF
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($this->frame0->getContents().$this->frame1->getContents().$this->frame2->getContents().$this->frame3->getContents().$this->frame4->getContents().$this->frame5->getContents());
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // write and open file
        file_put_contents('app/output/document.pdf', $dompdf->output());

        // open window to show pdf
        $window = TWindow::create('Caixa do Dia', 0.8, 0.8);
        $object = new TElement('iframe');
        $object->src  = 'app/output/document.pdf';
        $object->type  = 'application/pdf';
        $object->style = "width: 100%; height:calc(100% - 10px)";
        $window->add($object);
        $window->show();
    }

}