<?php

class CaixaDiaList extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        $this->CxInicial = 0;
        $this->VlInicial = 0;

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        // creates the action button
        $button1 = new TButton('fecha');
        $button1->setAction(new TAction(array($this, 'onFecha')), 'FECHAR O CAIXA');
        $button1->class = 'btn btn-success btn-lg btn-block';

        $button2 = new TButton('reabre');
        $button2->setAction(new TAction(array($this, 'onReAbre')), 'REABRE O CAIXA');
        $button2->class = 'btn btn-danger btn-lg btn-block';

        // create the datagrid - Contadores
        $this->datagrid0 = new TQuickGrid;
        $this->datagrid0->style = 'width: 100%';
        $this->datagrid0->addQuickColumn('FECHAMENTO'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid0->addQuickColumn('APURADO','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->createModel();

        // Botões Máquinas
        $bt1 = new TButton('bt1');
        $bt1->setAction(new TAction(array('LeiFinalForm','onReload')),'Cadastra Partida');
        $bt1->class = 'btn btn-info';

        $bt2 = new TButton('bt2');
        $bt2->setAction(new TAction(array('LeituraDiaList','onReload')),'Partidas do Dia');
        $bt2->class = 'btn btn-success';

        $hbox1 = new THBox;
        $hbox1->addRowSet( $bt1, $bt2);

        // Botões Caixa
        $bt4 = new TButton('bt4');
        $bt4->setAction(new TAction(array('ClienteForm','onReload')),'Clientes');
        $bt4->class = 'btn btn-primary';

        $bt5 = new TButton('bt5');
        $bt5->setAction(new TAction(array('ValeForm','onReload')),'Vales/Empréstimos');
        $bt5->class = 'btn btn-warning';

        $bt6 = new TButton('bt6');
        $bt6->setAction(new TAction(array('LancaForm','onReload')),'Despesas');
        $bt6->class = 'btn btn-danger';
        $hbox2 = new THBox;
        $hbox2->addRowSet( $bt4, $bt5, $bt6 );

        // create the datagrid - Receitas
        $this->datagrid1 = new TQuickGrid;
        $this->datagrid1->style = 'width: 100%';
        $this->datagrid1->addQuickColumn('RECEITA'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid1->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid1->createModel();

        // create the datagrid - Entrega do caixa
        $this->datagrid2 = new TQuickGrid;
        $this->datagrid2->style = 'width: 100%';
        $this->datagrid2->addQuickColumn('CAIXA A ENTREGAR'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid2->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid2->createModel();

        // create the datagrid - Vales
        $this->datagrid3 = new TQuickGrid;
        $this->datagrid3->style = 'width: 100%';
        $this->datagrid3->addQuickColumn('VALES'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid3->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid3->createModel();

        // create the datagrid - Despesas
        $this->datagrid4 = new TQuickGrid;
        $this->datagrid4->style = 'width: 100%';
        $this->datagrid4->addQuickColumn('DESPESAS'  ,'maquinas'  ,'left', 150);

        $contadores = $this->datagrid4->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid4->createModel();

        // creates a frame
        $this->frame = new TFrame;

        // creates an action button
        $print_button = new TButton('ptinr');
        $print_button->setAction(new TAction(array('CaixaDiaPrint', 'onPrint')), 'IMPRIMIR FECHAMENTO');
        $print_button->class = 'btn btn-info';

        // define the form fields
        $this->form_item->setFields(array($button1, $button2, $bt1, $bt2, $bt4, $bt5, $bt6, $print_button));

        $this->onReload();

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->datagrid0)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($hbox1);
        $vbox->add($this->datagrid1)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid2)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($hbox2);
        $vbox->add($this->datagrid3)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid4)->style = 'width: 100%; text-align: center;overflow-x:auto;';
//        $vbox->add($this->frame)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($button1)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        if(in_array('1', TSession::getValue('usergroupids'))){$vbox->add($button2)->style = 'width: 100%; text-align: center;overflow-x:auto;';}
//        $vbox->add($print_button)->style = 'width: 100%; text-align: left;';
        parent::add($vbox);
    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload($param = NULL)
    {
        try
        {
            $ini = parse_ini_file('app/config/application.ini', true);

            TTransaction::open('bingo');

            // Soma Clientes
            $repository = new TRepository('cliente');
            $clientes = $repository->load();
            $saldo_clientes = 0;
            foreach ($clientes as $cliente){
                $saldo_clientes += $cliente->saldo;
            }
            // Recupera Contadores
            $repository = new TRepository('leitura');
            $criteria = new TCriteria;
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $reads = $repository->load($criteria);
            $conta_entra = 0;
            $conta_saida = 0;
            $conta_card = array();
            $conta_ent = array();
            $conta_sai = array();
            $conta_cor[0] = 0;
            $conta_cor[1] = 0;
            for ($i = 0; $i <= 100; $i++) {
                $conta_card[] = 0;
                $conta_ent[] = 0;
                $conta_sai[] = 0;
            }
            $conta_linha = 0;
            $conta_bingo = 0;
            $conta_bingo2 = 0;
            $conta_extra = 0;
            foreach ($reads as $read){
                $conta_card[$read->valor] += $read->qtde;

                $conta_ent[$read->valor] += (float)(($read->qtde/6) * $read->valor);
                $conta_entra += (float)(($read->qtde/6) * $read->valor);

                $conta_sai[$read->valor] += (float)($read->linha+$read->bingo+$read->bingo2+$read->extra);
                $conta_saida += (float)($read->linha+$read->bingo+$read->bingo2+$read->extra);
                $conta_linha += $read->linha;
                $conta_bingo += $read->bingo;
                $conta_bingo2 += $read->bingo2;
                $conta_extra += $read->extra;

                $conta_cor[0] += $read->cortesia;
                $conta_cor[1] += ($read->cortesia/6)*$read->valor;
            }
            // Recupera Lançamentos
            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $criteria->setProperty('order', 'maquina asc, descricao asc, fechado asc');
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $customers = $repository->load($criteria);

            $this->datagrid0->clear();
            $this->datagrid1->clear();
            $this->datagrid2->clear();
            $this->datagrid3->clear();
            $this->datagrid4->clear();

            $sangria=0;
            $pagamentos=0;
            $inicial=0;
            $reforco=0;
            $aporte=0;
            $pagos=0;
            $dinheiro=0;
            $retirada=0;
            $cartao1=0;
            $cartao2=0;
            $cheque=0;
            $dolar=0;
            $despesas=0;
            $vales=0;
            $conta=1;
            $a_reforco=array();
            $a_aporte=array();
            $a_vales=array();
            $a_retiradas=array();
            $saldo_vales = 0;
            if ($customers) {
                foreach ($customers as $customer) {
                    if ($customer->maquina < 100) {
                        $pagamentos += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 101) {
                        $inicial += $customer->valor;
                    } elseif ($customer->maquina == 102) {
                        $a_reforco[$conta] = new stdclass();
                        $a_reforco[$conta]->maquinas = $customer->descricao;
                        $a_reforco[$conta]->contadores = $customer->valor;
                        $conta++;
                        $reforco += $customer->valor;
                    } elseif ($customer->maquina == 120) {
                        $a_aporte[$conta] = new stdclass();
                        $a_aporte[$conta]->maquinas = $customer->descricao;
                        $a_aporte[$conta]->contadores = $customer->valor;
                        $conta++;
                        $aporte += $customer->valor;
                    } elseif ($customer->maquina == 150) {
                        $a_retiradas[$conta] = new stdclass();
                        $a_retiradas[$conta]->maquinas = $customer->descricao;
                        $a_retiradas[$conta]->contadores = $customer->valor;
                        $conta++;
                        $retirada -= $customer->valor;
                    } elseif ($customer->maquina == 151) {
                        $cartao1 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 152) {
                        $cartao2 += ($customer->valor);
                    } elseif ($customer->maquina == 153) {
                        $cheque += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 500) {
                        $saldo_vales += ($customer->valor);
                    } elseif ($customer->maquina == 158 or $customer->maquina == 103) {
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid3->addItem($obj);
                        $vales += $customer->valor;
                    } elseif ($customer->maquina < 400){
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid4->addItem($obj);
                        $despesas += $customer->valor;
                    }
                    if ($customer->maquina < 400) {
                        $dinheiro += $customer->valor;
                    }
                }
            }
            $geral = $inicial + $reforco+$aporte+($conta_entra - $conta_saida)+$saldo_vales;

            for ($i = 0; $i <= 100; $i++) {
                if($conta_card[$i] != 0){
                    $obj = new stdclass();
                    $obj->maquinas   = 'SÉRIE DE '.number_format($i, 2, ',', '.').' - '.$conta_card[$i].' CARTÕES VENDIDOS';
                    $obj->contadores = $conta_ent[$i];
                    $this->datagrid0->addItem($obj);
                }
            }
            $obj = new stdclass();
            $obj->maquinas   = array_sum($conta_card).' CARTÕES VENDIDOS - ARRECADADO';
            $obj->contadores = $conta_entra;
            $this->datagrid0->addItem($obj);

//            $obj = new stdclass();
//            $obj->maquinas   = $conta_cor[0].' CARTÕES CORTESIA';
//            $obj->contadores = $conta_cor[1] * -1;
//            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'LINHAS PAGAS';
            $obj->contadores = $conta_linha * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'BINGOS PAGOS';
            $obj->contadores = $conta_bingo * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = '2º BINGOS PAGOS';
            $obj->contadores = $conta_bingo2 * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'PRÊMIOS EXTRAS';
            $obj->contadores = $conta_extra * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL DE PRÊMIOS';
            $obj->contadores = $conta_saida * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'SALDO';
            $obj->contadores = $conta_entra - array_sum($conta_sai);
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'CAIXA INICIAL';
            $obj->contadores = $inicial;
            $this->datagrid1->addItem($obj);

/*
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO DE VALES ANTERIOR';
            $obj->contadores = $saldo_vales;
            $this->datagrid1->addItem($obj);
*/
            if($reforco != 0) {
                foreach ($a_reforco as $key =>$item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_reforco[$key]->maquinas;
                    $obj->contadores = $a_reforco[$key]->contadores;
                    $this->datagrid1->addItem($obj);
                }
            }           
            if($aporte != 0) {
                foreach ($a_aporte as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_aporte[$key]->maquinas;
                    $obj->contadores = $a_aporte[$key]->contadores;
                    $this->datagrid1->addItem($obj);
                }
            }
            $obj = new stdclass();
            $obj->maquinas = 'SALDO DE CAIXA';
            $obj->contadores = $conta_entra - array_sum($conta_sai);
            $this->datagrid1->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL';
            $obj->contadores = $geral;
            $this->datagrid1->addItem($obj);

            $dinheiro =  $geral + $despesas - $cartao1 +  $cartao2 - $cheque - $retirada - $saldo_clientes;

            $obj = new stdclass();
            $obj->maquinas   = 'DINHEIRO';
            $obj->contadores = $dinheiro;
            $this->datagrid2->addItem($obj);
            if($cartao1 != 0) {
                $codigo = new codigo(151);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cartao1;
                $this->datagrid2->addItem($obj);
            }
            if($cartao2 != 0) {
                $codigo = new codigo(152);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cartao2;
                $this->datagrid2->addItem($obj);
            }
            if($cheque != 0) {
                $codigo = new codigo(153);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cheque;
                $this->datagrid2->addItem($obj);
            }

/*
            $obj = new stdclass();
            $obj->maquinas   = 'VALES';
            $obj->contadores = ($saldo_clientes - $saldo_vales);
            $this->datagrid2->addItem($obj);
*/
            $obj = new stdclass();
            $obj->maquinas = 'DESPESAS';
            $obj->contadores = $despesas*-1;
            $this->datagrid2->addItem($obj);

            if($retirada != 0) {
                foreach ($a_retiradas as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_retiradas[$key]->maquinas;
                    $obj->contadores = $a_retiradas[$key]->contadores * -1;
                    $this->datagrid2->addItem($obj);
                }
            }

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $dinheiro+$cartao1+$cartao2+$cheque+$saldo_clientes-$saldo_vales-$despesas+$retirada;
            $this->datagrid2->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $vales;
            $this->datagrid3->addItem($obj);
/*
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO DE VALES ATUAL';
            $obj->contadores = $saldo_clientes;
            $this->datagrid3->addItem($obj);
*/
            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $despesas;
            $this->datagrid4->addItem($obj);

            $azul=$dinheiro;
            $label = 'DINHEIRO('.number_format($dinheiro, 2, ',', '.').')';
            $taxa=0;
            If($cartao1+$cartao2 != 0){
                $label = $label.' + CARTÃO('.number_format($cartao1+$cartao2, 2, ',', '.').') ';
                if($ini['general']['txcard1'] != 0 and $cartao1 != 0){
                    $taxa += $cartao1 * ($ini['general']['txcard1']/100);
                }
                if($ini['general']['txcard2'] != 0 and $cartao2 != 0){
                    $taxa += $cartao2 * ($ini['general']['txcard2']/100);
                }
                if($taxa != 0){
                    $label = $label.'- TAXA CARTÃO '.'('.number_format($taxa, 2, ',', '.').')';
                }
                $azul += $cartao1 + $cartao2 - $taxa;
            }
            If($cheque != 0){$label = $label.' + CHEQUE('.number_format($cheque, 2, ',', '.').')';$azul += $cheque;}
            If($dolar != 0){$label = $label.' + MOEDA ESTRANGEIRA('.number_format($dolar, 2, ',', '.').')';$azul += $dolar;}
            If($retirada != 0){$label = $label.' + RETIRADAS('.number_format($retirada, 2, ',', '.').')';$azul += $retirada;}
            $label = $label.' - CAIXA INICIAL('.number_format($inicial, 2, ',', '.').')';
            $azul -= $inicial;
            If($reforco != 0){$label = $label.' - REFORÇO('.number_format($reforco, 2, ',', '.').')';$azul -= $reforco;}
            If($aporte != 0){$label = $label.' - APORTE('.number_format($aporte, 2, ',', '.').')';$azul -= $aporte;}
            $label = $label.' = ';
            $label1 = new TLabel('');
            $label1->setValue(number_format($azul, 2, ',', '.'));
            if($azul < 0){$label1->style = "color:red";}else{$label1->style = "color:blue";}

            $this->frame->add(new TLabel($label));
            $this->frame->add($label1);

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
            $this->CxInicial = $dinheiro;
            $this->VlInicial = $saldo_clientes;

        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
//        if($object->maquinas =='TOTAL DE ENTRADAS'){$row->style = "background: #00BFFF";}
//        if($object->maquinas =='TOTAL DE PAGAMENTOS'){$row->style = "background: #FF3030";}
        $row->style = "background: #C1CDC1";
        if($object->maquinas =='SALDO'){$row->style = "background: #00F5FF";}
        if($object->maquinas =='TOTAL'){$row->style = "background: #00F5FF";}
        if(strpos($object->maquinas,'DE PR')){$row->style = "background: #90EE90";}
        if(strpos($object->maquinas,'ARRECADADO')){$row->style = "background: #90EE90";}
        if(strpos($object->maquinas,'ATUAL')){$row->style = "background: #90EE90";}

        if ($stock < 0)
        {
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            return "<span style='color:blue'>$number</span>";
        }
    }

    /**
     * method onDelete()
     * executed whenever the user clicks at the delete button
     * Ask if the user really wants to delete the record
     * @param $param
     */
    public function onFecha($param)
    {
        // define the delete action
        $action = new TAction(array($this, 'Fecha'));
        $action->setParameters($param); // pass the key parameter ahead

        // shows a dialog to the user
        new TQuestion('Confirma o fechamento do caixa ?', $action);
    }

    /**
     * Saves the cart
     */
    public function Fecha()
    {
        try
        {
            TTransaction::open('bingo');

            $criteria = new TCriteria();
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $repository = new TRepository('movimento');
            $count = $repository->count($criteria);
            if($count < 3 and !(in_array('1', TSession::getValue('usergroupids')))){throw new Exception('Caixa Vazio');};

            $criteria = new TCriteria();
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $criteria->add(new TFilter('maquina', '<>', 0));
            $criteria->setProperty('order', 'id');
            $criteria->setProperty('limit' , 1);
            $repository = new TRepository('movimento');
            $result = $repository->load($criteria);
            $data = $result[0]->dia;

				// Alteração 08/02/2021 - calcular próximo dia quando fechar antes das 00:00
				$actual_day = date('Y-m-d H:i:s');
				$next_day = substr($actual_day,11,2);
				if($next_day > '16'){
					$next_fechamento = date('Y-m-d', strtotime("+1 days", strtotime($actual_day))) . ' 00:00:01';
				} else {
					$next_fechamento= $actual_day;
				}
				// -----------------------------------

            $conn = TTransaction::get(); // obtém a conexão

            $sql = "UPDATE tbl_movi SET fechado = '".$data."' WHERE fechado IS NULL";
            $sth = $conn->prepare($sql);
            $sth->execute();

            $sql = "UPDATE tbl_leitura SET fechado = '".$data."' WHERE fechado IS NULL";
            $sth = $conn->prepare($sql);
            $sth->execute();

            $registro = new Movimento;
            $registro->dia = $next_fechamento; // Alteração 29/07/2020 - calcular próximo dia quando fechar antes ds 00:00
            $registro->usuario = '0';
            $registro->maquina = '101';
            $registro->visita = '999';
            $registro->descricao = 'CAIXA INICIAL';
            $registro->valor = $this->CxInicial;
//            $registro->valor = 10000;
            $registro->store();

            $registro = new Movimento;
            $registro->dia = $next_fechamento; // Alteração 29/07/2020 - calcular próximo dia quando fechar antes ds 00:00
            $registro->usuario = '0';
            $registro->maquina = '500';
            $registro->visita = '999';
            $registro->descricao = 'VALES INICIAL';
            $registro->valor = $this->VlInicial;
            $registro->store();

            $registro = new fecha;
            $registro->dia = $data;
            $registro->store();

            TTransaction::close();
            new TMessage('info', 'Caixa fechado');
            $this->frame->clearChildren();
            $this->onReload();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    /**
     * Saves the cart
     */
    public function onReAbre()
    {
        try
        {
            TTransaction::open('bingo');

            $repository = new TRepository('fecha');
            $result = $repository->load();
            foreach ($result as $item){
                $data = $item->dia;
                $id = $item->id;
            }
            $object = new fecha($id);
            $object->delete();

            $conn = TTransaction::get(); // obtém a conexão
            $sql = "DELETE FROM tbl_movi WHERE fechado IS NULL";
            $sth = $conn->prepare($sql);
            $sth->execute();

            $conn = TTransaction::get(); // obtém a conexão
            $sql = "UPDATE tbl_movi SET fechado = NULL WHERE fechado = '".$data."'";
            $sth = $conn->prepare($sql);
            $sth->execute();

            $conn = TTransaction::get(); // obtém a conexão
            $sql = "DELETE FROM tbl_leitura WHERE fechado IS NULL";
            $sth = $conn->prepare($sql);
            $sth->execute();

            $conn = TTransaction::get(); // obtém a conexão
            $sql = "UPDATE tbl_leitura SET fechado = NULL WHERE fechado = '".$data."'";
            $sth = $conn->prepare($sql);
            $sth->execute();

            TTransaction::close();
            new TMessage('info', 'Caixa ReAberto');
            $this->frame->clearChildren();
            $this->onReload();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onSangria($param)
    {

        // form asking login and password
        $form = new TQuickForm('input_form');
        $form->style = 'padding:20px';

        $valor = new TEntry('valor');
        $valor->setInputType('tel');
        $valor->style = 'autocomplete="off"';


        $form->addQuickField('Valor da Sangria : ', $valor);

        $form->addQuickAction('Salvar', new TAction(array($this, 'onConfirm')), 'fa:check blue');

        // show the input dialog
        new TInputDialog('Lançamento de Sangria', $form);
        TScript::create('$("input[name=\'valor\']").focus();');

    }

    public function onConfirm($param)
    {
        $valor = str_replace(',', '.', $param['valor']);

        TTransaction::open('bingo');
        $registro = new Movimento;
        $registro->usuario = TSession::getValue('userid');
        $registro->maquina = '104';
        $registro->descricao = 'SANGRIA';
        $registro->valor = ($valor);
        $registro->visita=999;
        if($valor != 0){
            $registro->store();
            new TMessage('info', 'Registro Salvo com Sucesso');
        }
        TTransaction::close();
        $this->onReload();
    }
}