<?php
use Adianti\Database\TRecord;
class maquina extends TRecord
{
    const TABLENAME = 'tbl_maquinas';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}

    use SystemChangeLogTrait;

    public function __construct($id = NULL)
    {
        parent::__construct($id);
        parent::addAttribute('tipo');
        parent::addAttribute('credito');
        parent::addAttribute('ilha');
        parent::addAttribute('fabricante');
        parent::addAttribute('porcento');
        // Leitura tipo 0 = Sem Controle
        // Leitura tipo 1 = Contador anterior + 1
        // Leitura tipo 2 = Contador anterior + Valor * 4
        // Leitura tipo 3 = Contador anterior + Valor * 100
        parent::addAttribute('leitura');
    }
    /**
     * Returns the unit
     */
    public function get_maquina()
    {
        // loads the associated object
        if (empty($this->maquina))
            $this->maquina = new maquina($this->id);

        // returns the associated object
        return $this->maquina;
    }
}
?>