<?php
/**
 * SystemPreference
 *
 * @version    7.6
 * @package    model
 * @subpackage admin
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class config extends TRecord
{
    const TABLENAME  = 'tbl_config';
    const PRIMARYKEY = 'id';
    const IDPOLICY   = 'max'; // {max, serial}

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('value');
    }

    /**
     * Retorna uma preferência
     * @param $id Id da preferência
     */
    public static function getConfig($id)
    {
        $preference = new Config($id);
        return $preference->value;
    }

    /**
     * Altera uma preferência
     * @param $id  Id da preferência
     * @param $value Valor da preferência
     */
    public static function setConfig($id, $value)
    {
        $preference = Config::find($id);
        if ($preference)
        {
            $preference->value = $value;
            $preference->store();
        }
    }

    /**
     * Retorna um array com todas preferências
     */
    public static function getAllConfigs()
    {
        $rep = new TRepository('Config');
        $objects = $rep->load(new TCriteria);
        $dataset = array();

        if ($objects)
        {
            foreach ($objects as $object)
            {
                $property = $object->id;
                $value    = $object->value;
                $dataset[$property] = $value;
            }
        }
        return $dataset;
    }
}
