<?php

class LeituraSemList extends TPage
{
    Public $param;

    public function __construct($param)
    {
        parent::__construct();

        if(!array_key_exists('tipo', $param)){
            $param['tipo'] = 'Dia';
        }
        if(!array_key_exists('primeirodia', $param)){
            $param['primeirodia'] = NULL;
        }
        if(!array_key_exists('ultimodia', $param)){
            $param['ultimodia'] = NULL;
        }

        if($param['primeirodia'] == 'NULL'){
            $param['primeirodia'] = NULL;
            $param['ultimodia'] = NULL;
        }
        $this->param = $param;

        TTransaction::open('unit_database');

        // Recupera Contadores
        $repository = new TRepository('leitura');
        $criteria = new TCriteria;
        $criteria->setProperty('order', 'maquina asc, fechado asc');
        if($this->param['tipo'] == 'Semana'){
            $criteria->add(new TFilter('fechado', '>=', $this->param['primeirodia']));
            $criteria->add(new TFilter('fechado', '<=', $this->param['ultimodia']));
        } else {
            $criteria->add(new TFilter("substr(fechado,1,7)", '=', substr($this->param['ultimodia'],0,7)));
        }
        $leituras = $repository->load($criteria);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';

        // add the columns
        $this->datagrid->addQuickColumn('Máquina','maquina','center', 50);
        $this->datagrid->addQuickColumn('Tipo','tipo','center', 100);
        $this->datagrid->addQuickColumn('Entrada Inicial','ini_entra','center', 50);
        $this->datagrid->addQuickColumn('Saída Inicial','ini_sai','center', 50);
        $this->datagrid->addQuickColumn('Entrada Final','fim_entra','center',50);
        $this->datagrid->addQuickColumn('Saída Final','fim_sai','center',50);
        $jogou = $this->datagrid->addQuickColumn('Jogou', 'jogou', 'right', 50);
        $jogou->setTransformer(array('Utils', 'formatValueLei'));
        $pagou = $this->datagrid->addQuickColumn('Pagou', 'pagou', 'right',50);
        $pagou->setTransformer(array('Utils', 'formatValueLei'));
        $azul = $this->datagrid->addQuickColumn('L/P', 'azul', 'right',50);
        $azul->setTransformer(array('Utils', 'formatValueLei'));
        $this->datagrid->addQuickColumn('Retenção', 'retencao', 'center',50);

        // create the datagrid model
        $this->datagrid->createModel();

        $quebra='0';
        $ent_fim_ilha = 0;
        $ent_ini_ilha = 0;
        $jogou_ilha=0;
        $sai_fim_ilha = 0;
        $sai_ini_ilha = 0;
        $pagou_ilha=0;
        $azul_ilha=0;

        $ent_fim_geral = 0;
        $ent_ini_geral = 0;
        $jogou_geral=0;
        $sai_fim_geral = 0;
        $sai_ini_geral = 0;
        $pagou_geral=0;
        $azul_geral=0;
        $quebra_machine=0;
        $ordem=0;
        if ($leituras)
        {
            $guarda=1;
            foreach ($leituras as $leitura)
            {
                if ($guarda) {
                    $this->param['primeirodia'] = $leitura->fechado;
                    $guarda = 0;
                }
                if($quebra_machine == 0){
                    $ordem = 1;
                    $quebra_machine = $leitura->maquina;
                }elseif($quebra_machine != $leitura->maquina){
                    $ordem = 1;
                    $ent_ini_ilha += $obj->ini_entra;
                    $ent_fim_ilha += $obj->fim_entra;
                    $sai_fim_ilha += $obj->fim_sai;
                    $sai_ini_ilha += $obj->ini_sai;
                    $this->datagrid->addItem($obj);
                    $quebra_machine = $leitura->maquina;
                }
                if($ordem == 1){
                    $machine = new maquina($leitura->maquina);
                    $obj = new stdclass();
                    $obj->ilha = $machine->ilha;
                    $obj->maquina = $leitura->maquina;
                    $obj->tipo = $machine->tipo;
                    $obj->fim_entra = $leitura->fim_entra;
                    $obj->ini_entra = $leitura->ini_entra;
                    $obj->jogou = ($obj->fim_entra-$obj->ini_entra)*$leitura->credito;
                    $obj->fim_sai = $leitura->fim_sai;
                    $obj->ini_sai = $leitura->ini_sai;
                    $obj->pagou = ($obj->fim_sai-$obj->ini_sai)*$leitura->credito;
                    $obj->azul = $obj->jogou - $obj->pagou;
                    if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
                    elseif($obj->jogou == 0){$retencao = '';}
                    elseif($obj->pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
                    $obj->retencao = $retencao;
                    $ordem++;
                } else {
                    $obj->fim_entra = $leitura->fim_entra;
                    $jogou = ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                    $obj->jogou += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                    $obj->fim_sai = $leitura->fim_sai;
                    $pagou = ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                    $obj->pagou += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                    $obj->azul = $obj->jogou - $obj->pagou;
                    if($pagou == 0 AND $jogou == 0){$retencao = '';}
                    elseif($jogou == 0){$retencao = '';}
                    elseif(($pagou > $jogou) AND $jogou == 0){$retencao = '';}
                    elseif($pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
                    $obj->retencao = $retencao;
                }

                if($quebra == '0'){$quebra = $machine->ilha;}

                if($quebra != $machine->ilha){
                    $obj1 = new stdclass();
                    $obj1->ilha = $machine->ilha;
                    $obj1->maquina = '';
                    $obj1->tipo = 'TOTAIS';
                    $obj1->fim_entra = $ent_fim_ilha;
                    $obj1->ini_entra = $ent_ini_ilha;
                    $obj1->jogou = $jogou_ilha;
                    $obj1->fim_sai = $sai_fim_ilha;
                    $obj1->ini_sai = $sai_ini_ilha;
                    $obj1->pagou = $pagou_ilha;
                    $obj1->azul = $azul_ilha;
                    if($obj1->pagou == 0 AND $obj1->jogou == 0){$retencao = '';}
                    elseif(($obj->pagou > $obj->jogou) AND $obj->jogou == 0){$retencao = '';}
                    elseif($obj1->pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj1->fim_sai-$obj1->ini_sai) / ($obj1->fim_entra-$obj1->ini_entra))*100), 2, ',', '.');}
                    $obj1->retencao = $retencao;
                    $this->datagrid->addItem($obj1);
                    $ent_fim_ilha = 0;
                    $ent_ini_ilha = 0;
                    $jogou_ilha=0;
                    $sai_fim_ilha = 0;
                    $sai_ini_ilha = 0;
                    $pagou_ilha=0;
                    $azul_ilha=0;
                    $quebra = $machine->ilha;
                };

                $jogou_ilha += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                $pagou_ilha += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                $azul_ilha += (($leitura->fim_entra-$leitura->ini_entra) - ($leitura->fim_sai-$leitura->ini_sai))*$leitura->credito;

                $ent_fim_geral += $leitura->fim_entra;
                $ent_ini_geral += $leitura->ini_entra;
                $jogou_geral += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                $sai_fim_geral += $leitura->fim_sai;
                $sai_ini_geral += $leitura->ini_sai;
                $pagou_geral += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                $azul_geral += (($leitura->fim_entra-$leitura->ini_entra) - ($leitura->fim_sai-$leitura->ini_sai))*$leitura->credito;
            }
            $this->datagrid->addItem($obj);
            $ent_ini_ilha += $obj->ini_entra;
            $ent_fim_ilha += $obj->fim_entra;
            $sai_fim_ilha += $obj->fim_sai;
            $sai_ini_ilha += $obj->ini_sai;
            $obj = new stdclass();
            $obj->ilha = $machine->ilha;
            $obj->maquina = '';
            $obj->tipo = 'TOTAIS';
            $obj->fim_entra = $ent_fim_ilha;
            $obj->ini_entra = $ent_ini_ilha;
            $obj->jogou = $jogou_ilha;
            $obj->fim_sai = $sai_fim_ilha;
            $obj->ini_sai = $sai_ini_ilha;
            $obj->pagou = $pagou_ilha;
            $obj->azul = $azul_ilha;
            if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
            elseif(($obj->pagou > $obj->jogou) AND $obj->jogou == 0){$retencao = '';}
            elseif($obj->pagou == 0){$retencao = '100,00';}
            else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
            $obj->retencao = $retencao;
            $this->datagrid->addItem($obj);

            $obj = new stdclass();
            $obj->ilha = $machine->ilha;
            $obj->maquina = '';
            $obj->tipo = 'GERAL';
            $obj->fim_entra = '';
            $obj->ini_entra = '';
            $obj->jogou = $jogou_geral;
            $obj->fim_sai = '';
            $obj->ini_sai = '';
            $obj->pagou = $pagou_geral;
            $obj->azul = $azul_geral;
            if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
            elseif(($obj->pagou > $obj->jogou) AND $obj->jogou == 0){$retencao = '';}
            elseif($obj->pagou == 0){$retencao = '100,00';}
            else{$retencao = number_format((($azul_geral / $jogou_geral)*100), 2, ',', '.');}
            $obj->retencao = $retencao;
            $this->datagrid->addItem($obj);
        }

        // reset the criteria for record count
        $criteria->resetProperties();
        $count= $repository->count($criteria);

        // close the transaction
        TTransaction::close();

        $this->frame = new TFrame;
        $lab_cxdia = new TLabel('dia');
        $lab_cxdia->setFontSize(17);
        $lab_cxdia->setFontFace('Trebuchet MS');
        $lab_cxdia->setValue('LEITURAS - ');
        $this->frame->add($lab_cxdia);

        $lab_dia = new TLabel('dia');
        $lab_dia->setFontSize(17);
        $lab_dia->setFontFace('Trebuchet MS');
        if($this->param['tipo'] == 'Semana'){
            $form_dia = substr($this->param['primeirodia'],8,2).'/'.substr($this->param['primeirodia'],5,2).'/'.substr($this->param['primeirodia'],0,4)." A ".substr($this->param['ultimodia'],8,2).'/'.substr($this->param['ultimodia'],5,2).'/'.substr($this->param['ultimodia'],0,4);
        } else {
            $form_dia = substr($this->param['primeirodia'],8,2).'/'.substr($this->param['primeirodia'],5,2).'/'.substr($this->param['primeirodia'],0,4)." A ".substr($this->param['ultimodia'],8,2).'/'.substr($this->param['ultimodia'],5,2).'/'.substr($this->param['ultimodia'],0,4);
        }
        $lab_dia->setValue($form_dia);
        $this->frame->add($lab_dia);

        $act_print = new TAction(array($this, 'onPrint'));
        $act_print->setParameters($this->param);
        $bt_print = new TButton('print');
        $bt_print->setAction($act_print, 'IMPRIME A LEITURA');
        $bt_print->class = 'btn btn-warning btn-lg btn-block';

        // creates the form and a inner table
        $this->form = new TForm('form_pdf_report');
        $table = new TTable;
        $this->form->add($table);

        // define the form fields
        $this->form->setFields(array($bt_print));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->frame)->style = 'width: 100%; text-align: center;';
        $vbox->add($this->datagrid)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($bt_print)->style = 'width: 100%; text-align: left;';

        parent::add($vbox);
    }
    public function onPrint($param)
    {
        // converts the HTML template into PDF
        $dompdf = new \Dompdf\Dompdf();
        $paginas = file_get_contents('app/resources/styles-print.html').$this->frame->getContents().$this->datagrid->getContents();
        $dompdf->loadHtml($paginas);
//        $dompdf->setPaper('A4', 'landscape');
        $dompdf->setPaper(array(0,0,595,1200),'landscape');
        $dompdf->render();

        // write and open file
        $saida = 'app/output/leitura'.substr(time(),-4).'pdf';
        file_put_contents($saida, $dompdf->output());

        // open window to show pdf
        $window = TWindow::create('Leitura', 0.8, 0.8);
        $object = new TElement('iframe');
        $object->src  = $saida;
        $object->type  = 'application/pdf';
        $object->style = "width: 100%; height:calc(100% - 10px)";
        $window->add($object);
        $window->show();
    }
}