<?php

class FechaSemList extends TPage
{
    Public $param;

    public function __construct($param)
    {
        parent::__construct();

        if(!array_key_exists('tipo', $param)){
            $param['tipo'] = 'Dia';
        }
        if(!array_key_exists('primeirodia', $param)){
            $param['primeirodia'] = NULL;
        }
        if(!array_key_exists('ultimodia', $param)){
            $param['ultimodia'] = NULL;
        }

        if($param['primeirodia'] == 'NULL'){
            $param['primeirodia'] = NULL;
            $param['ultimodia'] = NULL;
        }
        $this->param = $param;

        TTransaction::open('unit_database');

        $porc_cartao1 = config::getConfig('txcard1');
        $porc_cartao2 = config::getConfig('txcard2');
        $porc_cartao3 = config::getConfig('txcard3');
        $porc_cartao4 = config::getConfig('txcard4');
        $semana = config::getConfig('semana');
        $socios = config::getConfig('socios');

        // Cria códigos de Despesa
        $a_despesas = array();
        $repository = new TRepository('codigo');
        $criteria = new TCriteria;
        $criteria->setProperty('order', 'id asc');
        $criteria->add(new TFilter('id', '>', 950));
        $codes = $repository->load($criteria);
        foreach ($codes as $code){
            $a_despesas[$code->id] = [$code->descricao,0,0,0,0,0,0,0,0];
        }
        // create the datagrid - Contadores
        $this->datagrid0 = new TQuickGrid;
        $this->datagrid0->style = 'width: 100%';
        $dias_semana = array(0=>'DOMINGO',1=>'SEGUNDA',2=>'TERÇA',3=>'QUARTA',4=>'QUINTA',5=>'SEXTA',6=>'SÁBADO',7=>'DOMINGO',8=>'SEGUNDA',9=>'TERÇA',10=>'QUARTA',11=>'QUINTA',12=>'SEXTA');
        $this->datagrid0->addQuickColumn('DESPESA / DIA'  ,'tipo'  ,'left', 150);
        $dia1 = $this->datagrid0->addQuickColumn($dias_semana[$semana  ],'dia1','center', 150);$dia1->setTransformer(array($this, 'formatsaldo'));
        $dia2 = $this->datagrid0->addQuickColumn($dias_semana[$semana+1],'dia2','center', 150);$dia2->setTransformer(array($this, 'formatsaldo'));
        $dia3 = $this->datagrid0->addQuickColumn($dias_semana[$semana+2],'dia3','center', 150);$dia3->setTransformer(array($this, 'formatsaldo'));
        $dia4 = $this->datagrid0->addQuickColumn($dias_semana[$semana+3],'dia4','center', 150);$dia4->setTransformer(array($this, 'formatsaldo'));
        $dia5 = $this->datagrid0->addQuickColumn($dias_semana[$semana+4],'dia5','center', 150);$dia5->setTransformer(array($this, 'formatsaldo'));
        $dia6 = $this->datagrid0->addQuickColumn($dias_semana[$semana+5],'dia6','center', 150);$dia6->setTransformer(array($this, 'formatsaldo'));
        $dia7 = $this->datagrid0->addQuickColumn($dias_semana[$semana+6],'dia7','center', 150);$dia7->setTransformer(array($this, 'formatsaldo'));
        $total=$this->datagrid0->addQuickColumn('TOTAL','total','center', 150);
        $total->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->createModel();

        $obj1 = new stdclass();$obj1->tipo = 'ENTRADA MÁQUINAS';$obj1->dia1 = 0;$obj1->dia2 = 0;$obj1->dia3 = 0;$obj1->dia4 = 0;$obj1->dia5 = 0;$obj1->dia6 = 0;$obj1->dia7 = 0;$obj1->total = 0;
        $obj2 = new stdclass();$obj2->tipo = 'SAÍDA MÁQUINAS';$obj2->dia1 = 0;$obj2->dia2 = 0;$obj2->dia3 = 0;$obj2->dia4 = 0;$obj2->dia5 = 0;$obj2->dia6 = 0;$obj2->dia7 = 0;$obj2->total = 0;
        $obj3 = new stdclass();$obj3->tipo = 'SALDO DAS MÁQUINAS';$obj3->dia1 = 0;$obj3->dia2 = 0;$obj3->dia3 = 0;$obj3->dia4 = 0;$obj3->dia5 = 0;$obj3->dia6 = 0;$obj3->dia7 = 0;$obj3->total = 0;
        $obj4 = new stdclass();$obj4->tipo = '';$obj4->dia1 = '9999999999';$obj4->dia2 = '9999999999';$obj4->dia3 = '9999999999';$obj4->dia4 = '9999999999';$obj4->dia5 = '9999999999';$obj4->dia6 = '9999999999';$obj4->dia7 = '9999999999';$obj4->total = '9999999999';
        $obj5 = new stdclass();$obj5->tipo = 'VALES (ENTRADA)';$obj5->dia1 = 0;$obj5->dia2 = 0;$obj5->dia3 = 0;$obj5->dia4 = 0;$obj5->dia5 = 0;$obj5->dia6 = 0;$obj5->dia7 = 0;$obj5->total = 0;
        $obj6 = new stdclass();$obj6->tipo = 'VALES (SAÍDA)';$obj6->dia1 = 0;$obj6->dia2 = 0;$obj6->dia3 = 0;$obj6->dia4 = 0;$obj6->dia5 = 0;$obj6->dia6 = 0;$obj6->dia7 = 0;$obj6->total = 0;
        $obj7 = new stdclass();$obj7->tipo = 'SALDO DOS VALES';$obj7->dia1 = 0;$obj7->dia2 = 0;$obj7->dia3 = 0;$obj7->dia4 = 0;$obj7->dia5 = 0;$obj7->dia6 = 0;$obj7->dia7 = 0;$obj7->total = 0;
        $obj8 = new stdclass();$obj8->tipo = $porc_cartao1.'% '.$a_despesas[951][0];$obj8->dia1 = 0;$obj8->dia2 = 0;$obj8->dia3 = 0;$obj8->dia4 = 0;$obj8->dia5 = 0;$obj8->dia6 = 0;$obj8->dia7 = 0;$obj8->total = 0;
        $obj9 = new stdclass();$obj9->tipo = $porc_cartao2.'% '.$a_despesas[952][0];$obj9->dia1 = 0;$obj9->dia2 = 0;$obj9->dia3 = 0;$obj9->dia4 = 0;$obj9->dia5 = 0;$obj9->dia6 = 0;$obj9->dia7 = 0;$obj9->total = 0;
        $obj10 = new stdclass();$obj10->tipo = $porc_cartao3.'% '.$a_despesas[953][0];$obj10->dia1 = 0;$obj10->dia2 = 0;$obj10->dia3 = 0;$obj10->dia4 = 0;$obj10->dia5 = 0;$obj10->dia6 = 0;$obj10->dia7 = 0;$obj10->total = 0;
        $obj11 = new stdclass();$obj11->tipo = $porc_cartao4.'% '.$a_despesas[954][0];$obj10->dia1 = 0;$obj11->dia2 = 0;$obj11->dia3 = 0;$obj11->dia4 = 0;$obj11->dia5 = 0;$obj11->dia6 = 0;$obj11->dia7 = 0;$obj11->total = 0;

        unset($a_despesas[951]);
        unset($a_despesas[952]);
        unset($a_despesas[953]);
        unset($a_despesas[954]);
        unset($a_despesas[955]);
        unset($a_despesas[956]);
        unset($a_despesas[957]);

        $conta = 1;
        $total_entra = 0;
        $total_sai = 0;
        $totval_entra = 0;
        $totval_sai = 0;
        $total_cartao1 = 0;
        $total_cartao2 = 0;
        $total_cartao3 = 0;
        $total_cartao4 = 0;
        $a_total_despesas=array('TOTAL',0,0,0,0,0,0,0,0);
//        foreach ($reads as $read) {
        $dia = date('Y-m-d', strtotime("-1 days",strtotime($this->param['primeirodia'])));
        for($nloop=1;$nloop < 8;$nloop++){
            $dia = date('Y-m-d', strtotime("+1 days",strtotime($dia))).' 00:00:00';
            $noite = date('Y-m-d', strtotime($dia)).' 23:59:59';

            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $criteria->setProperty('order', 'fechado asc');

            $criteria->add(new TFilter('fechado', 'BETWEEN', $dia));
            $criteria->add(new TFilter('', '', $noite));

            $leitura = $repository->load($criteria);
            $conta_entra = 0;
            $conta_saida = 0;
            $vales_entra = 0;
            $vales_saida = 0;
            $cartao1 = 0;
            $cartao2 = 0;
            $cartao3 = 0;
            $cartao4 = 0;
            $pix = 0;
            $cheque = 0;
            $dolar = 0;
            foreach ($leitura as $leit){
                if($leit->maquina == 904) {$conta_entra += (float)(($leit->valor));}
                if($leit->maquina < 800) {$conta_saida += (float)(($leit->valor*-1));}
                if($leit->maquina == 903) {$vales_entra += (float)(($leit->valor));}
                if($leit->maquina == 958) {$vales_saida += (float)(($leit->valor*-1));}
                if($leit->maquina == 951) {$cartao1 += (float)(($leit->valor)*($porc_cartao1/100));}
                if($leit->maquina == 952) {$cartao2 += (float)(($leit->valor)*($porc_cartao2/100));}
                if($leit->maquina == 953) {$pix += (float)($leit->valor);}
                if($leit->maquina == 954) {$cheque += (float)($leit->valor);}
                if($leit->maquina == 955) {$dolar += (float)($leit->valor);}
                if($leit->maquina == 956) {$cartao3 += (float)(($leit->valor)*($porc_cartao3/100));}
                if($leit->maquina == 957) {$cartao4 += (float)(($leit->valor)*($porc_cartao4/100));}
                foreach ($a_despesas as $key => $desp){
                    if($leit->maquina == $key) {
                        $a_despesas[$key][$conta] += (float)(($leit->valor));
                        $a_total_despesas[$conta] += (float)(($leit->valor));
                        $a_despesas[$key][8] += (float)(($leit->valor));
                        $a_total_despesas[8] += (float)(($leit->valor));
                    }
                }
            }

            // Soma cartão na despesa
            $a_total_despesas[$conta] += $cartao1+$cartao2+$cartao3+$cartao4;
            $a_total_despesas[8] += $cartao1+$cartao2+$cartao3+$cartao4;

            $total_entra += $conta_entra;
            $total_sai += $conta_saida;
            $totval_entra += $vales_entra;
            $totval_sai += $vales_saida;
            $total_cartao1 += $cartao1;
            $total_cartao2 += $cartao2;
            $total_cartao3 += $cartao3;
            $total_cartao4 += $cartao4;
            if($conta == 1) {
                $obj1->dia1 = $conta_entra;
                $obj2->dia1 = $conta_saida*-1;
                $obj3->dia1 = $conta_entra - $conta_saida;
                $obj5->dia1 = $vales_entra;
                $obj6->dia1 = $vales_saida*-1;
                $obj7->dia1 = $vales_entra - $vales_saida;
                $obj8->dia1 = $cartao1;
                $obj9->dia1 = $cartao2;
                $obj10->dia1 = $cartao3;
                $obj11->dia1 = $cartao4;
            }elseif($conta == 2) {
                $obj1->dia2 = $conta_entra;
                $obj2->dia2 = $conta_saida*-1;
                $obj3->dia2 = $conta_entra - $conta_saida;
                $obj5->dia2 = $vales_entra;
                $obj6->dia2 = $vales_saida*-1;
                $obj7->dia2 = $vales_entra - $vales_saida;
                $obj8->dia2 = $cartao1;
                $obj9->dia2 = $cartao2;
                $obj10->dia2 = $cartao3;
                $obj11->dia3 = $cartao4;
            }elseif($conta == 3) {
                $obj1->dia3 = $conta_entra;
                $obj2->dia3 = $conta_saida*-1;
                $obj3->dia3 = $conta_entra - $conta_saida;
                $obj5->dia3 = $vales_entra;
                $obj6->dia3 = $vales_saida*-1;
                $obj7->dia3 = $vales_entra - $vales_saida;
                $obj8->dia3 = $cartao1;
                $obj9->dia3 = $cartao2;
                $obj10->dia3 = $cartao3;
                $obj11->dia3 = $cartao4;
            }elseif($conta == 4) {
                $obj1->dia4 = $conta_entra;
                $obj2->dia4 = $conta_saida*-1;
                $obj3->dia4 = $conta_entra - $conta_saida;
                $obj5->dia4 = $vales_entra;
                $obj6->dia4 = $vales_saida*-1;
                $obj7->dia4 = $vales_entra - $vales_saida;
                $obj8->dia4 = $cartao1;
                $obj9->dia4 = $cartao2;
                $obj10->dia4 = $cartao3;
                $obj11->dia4 = $cartao4;
            }elseif($conta == 5) {
                $obj1->dia5 = $conta_entra;
                $obj2->dia5 = $conta_saida*-1;
                $obj3->dia5 = $conta_entra - $conta_saida;
                $obj5->dia5 = $vales_entra;
                $obj6->dia5 = $vales_saida*-1;
                $obj7->dia5 = $vales_entra - $vales_saida;
                $obj8->dia5 = $cartao1;
                $obj9->dia5 = $cartao2;
                $obj10->dia5 = $cartao3;
                $obj11->dia5 = $cartao4;
            }elseif($conta == 6) {
                $obj1->dia6 = $conta_entra;
                $obj2->dia6 = $conta_saida*-1;
                $obj3->dia6 = $conta_entra - $conta_saida;
                $obj5->dia6 = $vales_entra;
                $obj6->dia6 = $vales_saida*-1;
                $obj7->dia6 = $vales_entra - $vales_saida;
                $obj8->dia6 = $cartao1;
                $obj9->dia6 = $cartao2;
                $obj10->dia6 = $cartao3;
                $obj11->dia6 = $cartao4;
            }elseif($conta == 7) {
                $obj1->dia7 = $conta_entra;
                $obj2->dia7 = $conta_saida*-1;
                $obj3->dia7 = $conta_entra - $conta_saida;
                $obj5->dia7 = $vales_entra;
                $obj6->dia7 = $vales_saida*-1;
                $obj7->dia7 = $vales_entra - $vales_saida;
                $obj8->dia7 = $cartao1;
                $obj9->dia7 = $cartao2;
                $obj10->dia7 = $cartao3;
                $obj11->dia7 = $cartao4;
            }
            $conta++;
        }

        $obj1->total = $total_entra;
        $obj2->total = $total_sai*-1;
        $obj3->total = $total_entra - $total_sai;
        $obj5->total = $totval_entra;
        $obj6->total = $totval_sai*-1;
        $obj7->total = $totval_entra - $totval_sai;
        $obj8->total = $total_cartao1;
        $obj9->total = $total_cartao2;
        $obj10->total = $total_cartao3;
        $obj11->total = $total_cartao4;

        $this->datagrid0->addItem($obj1);
        $this->datagrid0->addItem($obj2);
        $this->datagrid0->addItem($obj3);
        $this->datagrid0->addItem($obj4);
        $this->datagrid0->addItem($obj5);
        $this->datagrid0->addItem($obj6);
        $this->datagrid0->addItem($obj7);
        $this->datagrid0->addItem($obj4);
        if($total_cartao1 != 0){$this->datagrid0->addItem($obj8);}
        if($total_cartao2 != 0){$this->datagrid0->addItem($obj9);}
        if($total_cartao3 != 0){$this->datagrid0->addItem($obj10);}
        if($total_cartao4 != 0){$this->datagrid0->addItem($obj11);}

        foreach ($a_despesas as $desp){
            $obj = new stdclass();
            $obj->tipo = $desp[0];
            $obj->dia1 = $desp[1];
            $obj->dia2 = $desp[2];
            $obj->dia3 = $desp[3];
            $obj->dia4 = $desp[4];
            $obj->dia5 = $desp[5];
            $obj->dia6 = $desp[6];
            $obj->dia7 = $desp[7];
            $obj->total = $desp[8];
            if($desp[8] != 0){$this->datagrid0->addItem($obj);}
        }

        $obj = new stdclass();
        $obj->tipo = 'TOTAL DE DESPESAS';
        $obj->dia1 = $a_total_despesas[1];
        $obj->dia2 = $a_total_despesas[2];
        $obj->dia3 = $a_total_despesas[3];
        $obj->dia4 = $a_total_despesas[4];
        $obj->dia5 = $a_total_despesas[5];
        $obj->dia6 = $a_total_despesas[6];
        $obj->dia7 = $a_total_despesas[7];
        $obj->total = $a_total_despesas[8];
        $this->datagrid0->addItem($obj);

        $this->datagrid0->addItem($obj4);

        $azul = $obj3->total + $obj7->total + $obj->total;

        $obj10 = new stdclass();
        if($azul < 0){$obj10->tipo = 'PREJUÍZO DA SEMANA';}else{$obj10->tipo = 'LUCRO DA SEMANA';}
        $obj10->dia1 = $obj3->dia1 + $obj7->dia1 + $obj->dia1;
        $obj10->dia2 = $obj3->dia2 + $obj7->dia2 + $obj->dia2;
        $obj10->dia3 = $obj3->dia3 + $obj7->dia3 + $obj->dia3;
        $obj10->dia4 = $obj3->dia4 + $obj7->dia4 + $obj->dia4;
        $obj10->dia5 = $obj3->dia5 + $obj7->dia5 + $obj->dia5;
        $obj10->dia6 = $obj3->dia6 + $obj7->dia6 + $obj->dia6;
        $obj10->dia7 = $obj3->dia7 + $obj7->dia7 + $obj->dia7;
        $obj10->total = $obj3->total + $obj7->total + $obj->total;
        $this->datagrid0->addItem($obj10);

        if( $socios > 1){
            $this->datagrid0->addItem($obj4);
            $obj10 = new stdclass();
            if($azul < 0){$obj10->tipo = 'PREJUÍZO INDIVIDUAL';}else{$obj10->tipo = 'LUCRO INDIVIDUAL';}
            $obj10->dia1 = ($obj3->dia1 + $obj7->dia1 + $obj->dia1)/$socios;
            $obj10->dia2 = ($obj3->dia2 + $obj7->dia2 + $obj->dia2)/$socios;
            $obj10->dia3 = ($obj3->dia3 + $obj7->dia3 + $obj->dia3)/$socios;
            $obj10->dia4 = ($obj3->dia4 + $obj7->dia4 + $obj->dia4)/$socios;
            $obj10->dia5 = ($obj3->dia5 + $obj7->dia5 + $obj->dia5)/$socios;
            $obj10->dia6 = ($obj3->dia6 + $obj7->dia6 + $obj->dia6)/$socios;
            $obj10->dia7 = ($obj3->dia7 + $obj7->dia7 + $obj->dia7)/$socios;
            $obj10->total = ($obj3->total + $obj7->total + $obj->total)/$socios;
            $this->datagrid0->addItem($obj10);
        }

        // creates a frame
        $this->frame = new TFrame;

        $lab_cxdia = new TLabel('dia');
        $lab_cxdia->setFontSize(17);
        $lab_cxdia->setFontFace('Trebuchet MS');
        $lab_cxdia->setValue('FECHAMENTOS - ');
        $this->frame->add($lab_cxdia);

        $lab_dia = new TLabel('dia');
        $lab_dia->setFontSize(17);
        $lab_dia->setFontFace('Trebuchet MS');
        $form_dia = substr($this->param['primeirodia'],8,2).'/'.substr($this->param['primeirodia'],5,2).'/'.substr($this->param['primeirodia'],0,4)." A ".substr($this->param['ultimodia'],8,2).'/'.substr($this->param['ultimodia'],5,2).'/'.substr($this->param['ultimodia'],0,4);
        $lab_dia->setValue($form_dia);
        $this->frame->add($lab_dia);

        // reset the criteria for record count
        $criteria->resetProperties();
        $count= $repository->count($criteria);

        // close the transaction
        TTransaction::close();
        $this->loaded = true;

        // creates the form and a inner table
        $this->form = new TForm('form_pdf_report');
        $table = new TTable;
        $this->form->add($table);

        $act_print = new TAction(array($this, 'onPrint'));
        $act_print->setParameters($this->param);
        $bt_print = new TButton('print');
        $bt_print->setAction($act_print, 'IMPRIME O FECHAMENTO');
        $bt_print->class = 'btn btn-warning btn-lg btn-block';

        // define the form fields
        $this->form->setFields(array($bt_print));

        // add a row for the form action
//        $table->addRowSet($save_button);

        // define wich are the form fields
//        $this->form->setFields(array($save_button));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->frame);
        $vbox->add($this->datagrid0)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($bt_print)->style = 'width: 100%; text-align: left;';
        parent::add($vbox);

        // converts the HTML template into PDF
//        $this->dompdf = new \Dompdf\Dompdf();
//        $this->dompdf->loadHtml($this->datagrid0->getContents());
//        $this->dompdf->setPaper('A4', 'portrait');
//        $this->dompdf->render();

    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        if($stock == '9999999999'){return "";}
        $number = number_format($stock, 2, ',', '.');
        if($stock < 0){$number = number_format($stock*-1, 2, ',', '.');}
//        if($object->maquinas =='TOTAL DE ENTRADAS'){$row->style = "background: #00BFFF";}
//        if($object->maquinas =='TOTAL DE PAGAMENTOS'){$row->style = "background: #FF3030";}
        $row->style = "background: #C1CDC1";
        if($object->tipo =='SALDO DAS MÁQUINAS'){$row->style = "background: #90EE90";}
        if($object->tipo =='SALDO DOS VALES'){$row->style = "background: #90EE90";}
        if($object->tipo =='TOTAL DE DESPESAS'){$row->style = "background: #90EE90";}
        if($object->tipo =='LUCRO DA SEMANA'){$row->style = "background: #00BFFF";}
        if($object->tipo =='PREJUÍZO DA SEMANA'){$row->style = "background: #FFFF00";}
        if(sprintf("%.2f", $stock) == '-0.00' or sprintf("%.2f", $stock) == '0.00'){
            return "<span style='color:blue'>$number</span>";
        }elseif ($stock < 0){
            return "<span style='color:red'>$number</span>";
        }else{
            return "<span style='color:blue'>$number</span>";
        }

    }
    public function onPrint($param)
    {
        // converts the HTML template into PDF
        $dompdf = new \Dompdf\Dompdf();
        $paginas = $this->frame->getContents().$this->datagrid0->getContents();
        $dompdf->loadHtml($paginas);
//        $dompdf->setPaper('A4', 'landscape');
        $dompdf->setPaper(array(0,0,595,1141),'landscape');
        $dompdf->render();

        // write and open file
        file_put_contents('app/output/document.pdf', $dompdf->output());

        // open window to show pdf
        $window = TWindow::create('Caixa do Dia', 0.8, 0.8);
        $object = new TElement('iframe');
        $object->src  = 'app/output/document.pdf';
        $object->type  = 'application/pdf';
        $object->style = "width: 100%; height:calc(100% - 10px)";
        $window->add($object);
        $window->show();
    }
}
