<?php


class MaquinaList extends TStandardList
{
    protected $form;     // registration form
    protected $datagrid; // listing
    protected $pageNavigation;
    protected $formgrid;
    protected $deleteButton;
    protected $transformCallback;

    /**
     * Page constructor
     */
    public function __construct()
    {
        parent::__construct();

        parent::setDatabase('unit_database');            // defines the database
        parent::setActiveRecord('maquina');   // defines the active record
        parent::setDefaultOrder('id', 'asc');         // defines the default order
        parent::addFilterField('tipo', '=', 'tipo'); // filterField, operator, formField
        parent::setLimit(200);

        // creates the form
        $this->form = new BootstrapFormBuilder('form_search_Maquina');
        $this->form->setFormTitle('Máquinas');

        // create the form fields
        $id = new THidden('id');
        $tipo = new TDBCombo('tipo','unit_database','Maquina','tipo','tipo');

        // add the fields
        $this->form->addFields( [new TLabel('Tipo')], [$tipo] );

        $tipo->setSize('70%');

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue('Maquina_filter_data') );

        // add the search form actions
        $btn = $this->form->addAction(_t('Find'), new TAction(array($this, 'onSearch')), 'fa:search');
        $btn->class = 'btn btn-sm btn-primary';
        $this->form->addAction(_t('New'),  new TAction(array('MaquinaForm', 'onEdit')), 'bs:plus-sign green');

        // creates a DataGrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->datatable = 'true';
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);


        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Máquina', 'center');
        $column_tipo = new TDataGridColumn('tipo', 'Tipo', 'center');
        $column_credito = new TDataGridColumn('credito', 'Crédito', 'center');
        $column_ilha = new TDataGridColumn('ilha', 'Ilha', 'center');
        $column_fabri = new TDataGridColumn('fabricante', 'Fabricante', 'center');
        $column_porcento = new TDataGridColumn('porcento', 'Comissão', 'center');
        $column_leitura = new TDataGridColumn('leitura', 'leitura', 'center');

        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_tipo);
        $this->datagrid->addColumn($column_credito);
        $this->datagrid->addColumn($column_ilha);
        $this->datagrid->addColumn($column_fabri);
        $this->datagrid->addColumn($column_porcento);
        $this->datagrid->addColumn($column_leitura);

        $column_credito->setTransformer( function($value, $object, $row) {
            return number_format($value, 2, ',', '.');
        });

        // creates the datagrid column actions
        $order_id = new TAction(array($this, 'onReload'));
        $order_id->setParameter('order', 'id');
        $column_id->setAction($order_id);

        $order_porc = new TAction(array($this, 'onReload'));
        $order_porc->setParameter('order', 'tipo');
        $column_tipo->setAction($order_porc);

        // create EDIT action
        $action_edit = new TDataGridAction(array('MaquinaForm', 'onEdit'));
        $action_edit->setButtonClass('btn btn-default');
        $action_edit->setLabel(_t('Edit'));
        $action_edit->setImage('far:edit');
        $action_edit->setField('id');
        $this->datagrid->addAction($action_edit);

        if(Utils::isAdmin()) {
            // create DELETE action
            $action_del = new TDataGridAction(array($this, 'onDelete'));
            $action_del->setButtonClass('btn btn-default');
            $action_del->setLabel(_t('Delete'));
            $action_del->setImage('far:trash-alt red');
            $action_del->setField('id');
            $this->datagrid->addAction($action_del);
        }

        // create the datagrid model
        $this->datagrid->createModel();

        // create the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        $panel = new TPanelGroup;
        $panel->add($this->datagrid);
        $panel->addFooter($this->pageNavigation);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 90%';
        $container->add($this->form);
        $container->add($panel);

        parent::add($container);
    }
}
