<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Control\TWindow;
use Adianti\Database\TCriteria;
use Adianti\Database\TFilter;
use Adianti\Database\TRepository;
use Adianti\Database\TTransaction;
use Adianti\Registry\TSession;
use Adianti\Widget\Base\TScript;
use Adianti\Widget\Base\TElement;
use Adianti\Widget\Container\TTable;
use Adianti\Widget\Container\TVBox;
use Adianti\Widget\Container\THBox;
use Adianti\Widget\Container\TFrame;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Wrapper\TQuickForm;
use Adianti\Widget\Dialog\TQuestion;
use Adianti\Widget\Dialog\TInputDialog;
use Adianti\Widget\Form\TButton;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TForm;
use Adianti\Widget\Form\TLabel;
use Adianti\Widget\Wrapper\TQuickGrid;
use Adianti\Widget\Datagrid\TDataGridAction;

class CaixaList extends TPage
{
    Public $param;

    public function __construct($param)
    {
        if(!isset($param['tipo'])){
            $param['tipo'] = 'Dia';
            $param['primeirodia'] = NULL;
            $param['ultimodia'] = NULL;
        }

        $this->param = $param;

        $this->CxInicial = 0;
        $this->VlInicial = 0;

        parent::__construct();

        TTransaction::open('unit_database');
        $pagamento = config::getConfig('pagamento');
        $valesclientes = config::getConfig('valesclientes');
        $reabre = config::getConfig('Reabre');
        if(TSession::getValue('usercustomcode') == 'naoreabre'){
            $reabre = 0;
        }
        if($this->param['tipo'] == 'Mensal'){
            $fechas = fecha::where("substr(dia,1,7)", '=', substr($this->param['primeirodia'],0,7))->load();
            $this->param['primeirodia'] = $fechas[0]->dia;
            $this->param['ultimodia'] = $fechas[count($fechas)-1]->dia;
        }
        TTransaction::close();
        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);
        $this->frame = new TFrame;

        // Se Diario verifica pagamento
        if($this->param['tipo'] == 'Dia'){
            $vencimento = new DateTime($pagamento);
            $data_hora  = new DateTime('now');
            $dias_dif = $vencimento->diff($data_hora);
            $dias_win = $dias_dif->days;

            if($data_hora < $vencimento) {
                $this->text_win = 'MENSALIDADE COM VENCIMENTO EM : <B>' . $vencimento->format('d/m/Y') . '</B>';
            }else{
                $this->text_win = 'MENSALIDADE <B>VENCEU</B> EM '.$vencimento->format('d/m/Y');
                $dias_win = $dias_win * -1;
                echo "<embed src='app/images/notificacao.mp3'width='0' height='0'>";
                new TMessage('warning', $this->text_win);
            }
        } elseif($this->param['tipo'] == 'Fechado') {
            $dias_win = 0;
            $this->text_win = 'CAIXA DO DIA - '.substr($this->param['primeirodia'],8,2).'/'.substr($this->param['primeirodia'],5,2).'/'.substr($this->param['primeirodia'],0,4).' - '.substr($this->param['primeirodia'],11,2).':'.substr($this->param['primeirodia'],14,2).':'.substr($this->param['primeirodia'],17,2);
        } else {
            $dias_win = 0;
            $this->text_win = 'CAIXAS - '.substr($this->param['primeirodia'],8,2).'/'.substr($this->param['primeirodia'],5,2).'/'.substr($this->param['primeirodia'],0,4).' A '.substr($this->param['ultimodia'],8,2).'/'.substr($this->param['ultimodia'],5,2).'/'.substr($this->param['ultimodia'],0,4);
        }
        $button_win = new TButton('win');
        $button_win->setAction(new TAction(array($this, 'onWin')), $this->text_win);
        $button_win->class = 'btn btn-danger btn-lg btn-block';

        // create the datagrid - Máquinas
        $this->datagrid_maq = new TQuickGrid;
        $this->datagrid_maq->style = 'width: 100%';
        $this->datagrid_maq->addQuickColumn('MÁQUINAS'  ,'maquinas'  ,'left');
        $contadores = $this->datagrid_maq->addQuickColumn('LEITURA','contadores','center');
        $contadores->setTransformer(array('Utils', 'formatValueCx'));
        $manual = $this->datagrid_maq->addQuickColumn('MANUAL'    ,'manual'    ,'center');
        $manual->setTransformer(array('Utils', 'formatValueCx'));
        $diferenca = $this->datagrid_maq->addQuickColumn('DIFERENÇA' ,'diferenca' ,'center');
        $diferenca->setTransformer(array('Utils', 'formatValueCx'));
        if($param['primeirodia'] == NULL){
            $action1 = new TDataGridAction(array('DifList','onReload'), ['diferenca' => '{diferenca}'] );
        } else {
            $action1 = new TDataGridAction(array('DifList','onReload'), ['primeirodia' => $param['primeirodia'],'ultimodia' => $param['primeirodia'], 'diferenca' => '{diferenca}', 'tipo' => $param['tipo']] );
        }
        $action1->setDisplayCondition( array($this, 'displayColumn') );
        $this->datagrid_maq->addAction($action1);

        $this->datagrid_maq->createModel();
        // Botões Máquinas
        $bt_sangria = new TButton('bt1');
        $bt_sangria->setAction(new TAction(array($this,'onSangria')),'Sangria');
        $bt_sangria->class = 'btn btn-info';
        $bt_cambio = new TButton('bt2');
        $bt_cambio->setAction(new TAction(array('TransferForm','onReload')),'Câmbio');
        $bt_cambio->class = 'btn btn-success';
        $bt_desp = new TButton('bt3');
        $bt_desp->setAction(new TAction(array('LancaForm','onReload')),'Despesas');
        $bt_desp->class = 'btn btn-danger';
        $hbox1 = new THBox;
        $hbox1->addRowSet( $bt_sangria, $bt_cambio, $bt_desp );

        // create the datagrid - Receitas
        $this->datagrid_rece = new TQuickGrid;
        $this->datagrid_rece->style = 'width: 100%';
        $this->datagrid_rece->addQuickColumn('RECEITA'  ,'maquinas'  ,'left');
        $contadores = $this->datagrid_rece->addQuickColumn('VALOR','contadores','center');
        $contadores->setTransformer(array('Utils', 'formatValueCx'));
        $this->datagrid_rece->createModel();
        // Botões Receita
        $bt_clientes = new TButton('bt4');
        $bt_clientes->setAction(new TAction(array('ClienteForm','onReload')),'Clientes');
        $bt_clientes->class = 'btn btn-primary';
        $bt_vales = new TButton('bt5');
        $bt_vales->setAction(new TAction(array('ValeForm','onReload')),'Vales/Empréstimos');
        $bt_vales->class = 'btn btn-success';
        $bt_movi = new TButton('bt6');
        $bt_movi->setAction(new TAction(array('MoviList','onReload')),'Movimento do dia');
        $bt_movi->class = 'btn btn-warning';
        $bt_atende = new TButton('bt9');
        $bt_atende->setAction(new TAction(array('AtendenteForm','onReload')),'Atendente');
        $bt_atende->class = 'btn btn-success';
        $hbox2 = new THBox;
        if($valesclientes){
            $hbox2->addRowSet( $bt_clientes, $bt_vales, $bt_movi, $bt_atende );
        }else{
            $hbox2->addRowSet($bt_movi, $bt_atende );
        }

        // create the datagrid - Caixa a Entregar
        $this->datagrid_caixa = new TQuickGrid;
        $this->datagrid_caixa->style = 'width: 100%';
        $this->datagrid_caixa->addQuickColumn('CAIXA A ENTREGAR'  ,'maquinas'  ,'left');
        $contadores = $this->datagrid_caixa->addQuickColumn('VALOR','contadores','center');
        $contadores->setTransformer(array('Utils', 'formatValueCx'));
        $this->datagrid_caixa->createModel();
        // Botões Leitura
        $bt7 = new TButton('bt7');
        $bt7->setAction(new TAction(array('LeiFinalForm','onReload')),'Leitura Final');
        $bt7->class = 'btn btn-info';
        $bt8 = new TButton('bt8');
        $bt8->setAction(new TAction(array('LeituraList','onReload')),'Leitura do Dia');
        $bt8->class = 'btn btn-danger';
        $hbox3 = new THBox;
        $hbox3->addRowSet( $bt7, $bt8 );

        if($valesclientes) {
            // create the datagrid - Vales
            $this->datagrid_vales = new TQuickGrid;
            $this->datagrid_vales->style = 'width: 100%';
            $this->datagrid_vales->addQuickColumn('VALES', 'maquinas', 'left');
            $contadores = $this->datagrid_vales->addQuickColumn('VALOR', 'contadores', 'center');
            $contadores->setTransformer(array('Utils', 'formatValueCx'));
            $this->datagrid_vales->createModel();
        }

        // create the datagrid - Despesas
        $this->datagrid_desp = new TQuickGrid;
        $this->datagrid_desp->style = 'width: 100%';
        $this->datagrid_desp->addQuickColumn('DESPESAS'  ,'maquinas'  ,'left');
        $contadores = $this->datagrid_desp->addQuickColumn('VALOR','contadores','center');
        $contadores->setTransformer(array('Utils', 'formatValueCx'));
        $this->datagrid_desp->createModel();

        // creates the action button
        $bt_fecha = new TButton('fecha');
        $bt_fecha->setAction(new TAction(array($this, 'onFecha')), 'FECHAR O CAIXA');
        $bt_fecha->class = 'btn btn-success btn-lg btn-block';

        $bt_reabre = new TButton('reabre');
        $bt_reabre->setAction(new TAction(array($this, 'onReAbre')), 'REABRE O CAIXA ANTERIOR');
        $bt_reabre->class = 'btn btn-info btn-lg btn-block';

        $act_print = new TAction(array($this, 'onPrint'));
        $act_print->setParameters($this->param);
        $bt_print = new TButton('print');
        $bt_print->setAction($act_print, 'IMPRIME O CAIXA');
        $bt_print->class = 'btn btn-warning btn-lg btn-block';

        $this->onReload();
        $this->form_item->setFields(array($bt_fecha, $bt_reabre, $bt_print, $button_win, $bt_sangria, $bt_cambio, $bt_desp, $bt_clientes, $bt_vales, $bt_movi, $bt7, $bt8, $bt_atende));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;overflow-x:auto;';
        if($dias_win <= 2) {
            $vbox->add($button_win)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        }
        if($dias_win > -5) {
            if($this->param['tipo'] == 'Dia'){
                $vbox->add($this->datagrid_maq)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($hbox1);
                $vbox->add($this->datagrid_rece)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($hbox2);
                $vbox->add($this->datagrid_caixa)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($hbox3);
                if ($valesclientes) {
                    $vbox->add($this->datagrid_vales)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                }
                $vbox->add($this->datagrid_desp)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($this->frame)->style = 'width: 100%; text-align: center;';
                $vbox->add($bt_fecha)->style = 'width: 100%; text-align: center;';
                if($reabre){
                    $vbox->add($bt_reabre)->style = 'width: 100%; text-align: center;';
                }
                $vbox->add($bt_print)->style = 'width: 100%; text-align: center;';
            } else {
                $vbox->add($this->datagrid_maq)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($this->datagrid_rece)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($this->datagrid_caixa)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                if ($valesclientes) {
                    $vbox->add($this->datagrid_vales)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                }
                $vbox->add($this->datagrid_desp)->style = 'width: 100%; text-align: center;overflow-x:auto;';
                $vbox->add($this->frame)->style = 'width: 100%; text-align: center;';
                $vbox->add($bt_print)->style = 'width: 100%; text-align: center;';
            }
        }
        parent::add($vbox);
    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload()
    {
        try
        {
            TTransaction::open('unit_database');

            $txcard1 = config::getConfig('txcard1');
            $txcard2 = config::getConfig('txcard2');
            $txcard3 = config::getConfig('txcard3');
            $txcard4 = config::getConfig('txcard4');
            $valesclientes = config::getConfig('valesclientes');

/*
            $saldo_clientes = 0;
            if($this->param['tipo'] == 'Dia'){
                // Soma Clientes
                $repository = new TRepository('cliente');
                $clientes = $repository->load();
                foreach ($clientes as $cliente){
                    $saldo_clientes += $cliente->saldo;
                }
            }
*/
            // Critério de Datas
            if($this->param['tipo'] == 'Dia'){
                $crt_date1 = new TFilter('fechado', 'IS', NULL);
                $crt_date2 = new TFilter('fechado', 'IS', NULL);
            } else {
                $crt_date1 = new TFilter('fechado', '>=', $this->param['primeirodia']);
                $crt_date2 = new TFilter('fechado', '<=', $this->param['ultimodia']);
            }
            // Recupera Contadores
            $repository = new TRepository('leitura');
            $criteria = new TCriteria;
            $criteria->add($crt_date1);
            $criteria->add($crt_date2);
            $reads = $repository->load($criteria);
            $conta_entra = 0;
            $conta_saida = 0;
            foreach ($reads as $read){
                $conta_entra += (float)(($read->fim_entra - $read->ini_entra) * $read->credito);
                $conta_saida += (float)(($read->fim_sai   - $read->ini_sai)   * $read->credito);
            }
            // Recupera Lançamentos
            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $criteria->setProperty('order', 'maquina asc, descricao asc, fechado asc');
            $criteria->add($crt_date1);
            $criteria->add($crt_date2);
            $customers = $repository->load($criteria);

            $this->datagrid_maq->clear();
            $this->datagrid_rece->clear();
            $this->datagrid_caixa->clear();
            if($valesclientes) {
                $this->datagrid_vales->clear();
            }
            $this->datagrid_desp->clear();

            $sangria=0;
            $pagamentos=0;
            $inicial=0;
            $reforco=0;
            $aporte=0;
            $dinheiro=0;
            $retirada=0;
            $ccred=0;
            $cdeb=0;
            $pix=0;
            $cheque=0;
            $dolar=0;
            $card_1=0;
            $card_2=0;
            $despesas=0;
            $vales=0;
            $conta=1;
            $a_reforco=array();
            $a_aporte=array();
            $a_retiradas=array();
            $saldo_vales_anterior = 0;
            if ($customers) {
                foreach ($customers as $customer) {
                    if ($customer->maquina < 800) {
                        $pagamentos += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 850) {
                        if($this->param['tipo'] == 'Semana' or $this->param['tipo'] == 'Mensal') {
                            if($customer->fechado == $this->param['primeirodia']){
                                $saldo_vales_anterior += ($customer->valor);
                            }
                        } else {
                            $saldo_vales_anterior += ($customer->valor);
                        }
                    } elseif ($customer->maquina == 901) {
                        if($this->param['tipo'] == 'Semana' or $this->param['tipo'] == 'Mensal') {
                            if($customer->fechado == $this->param['primeirodia']){
                                $inicial = $customer->valor;
                            }
                        } else {
                            $inicial += $customer->valor;
                        }
                    } elseif ($customer->maquina == 902) {
                        $a_reforco[$conta] = new stdclass();
                        $a_reforco[$conta]->maquinas = $customer->descricao;
                        $a_reforco[$conta]->contadores = $customer->valor;
                        $conta++;
                        $reforco += $customer->valor;
                    } elseif ($customer->maquina == 904) {
                        $sangria += $customer->valor;
                    } elseif ($customer->maquina == 920) {
                        $a_aporte[$conta] = new stdclass();
                        $a_aporte[$conta]->maquinas = $customer->descricao;
                        $a_aporte[$conta]->contadores = $customer->valor;
                        $conta++;
                        $aporte += $customer->valor;
                    } elseif ($customer->maquina == 950) {
                        $a_retiradas[$conta] = new stdclass();
                        $a_retiradas[$conta]->maquinas = $customer->descricao;
                        $a_retiradas[$conta]->contadores = $customer->valor;
                        $conta++;
                        $retirada -= $customer->valor;
                    } elseif ($customer->maquina == 951) {
                        $ccred += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 952) {
                        $cdeb += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 953) {
                        $pix += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 954) {
                        $cheque += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 955) {
                        $dolar += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 956) {
                        $card_1 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 957) {
                        $card_2 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 958 or $customer->maquina == 903) {
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid_vales->addItem($obj);
                        $vales += $customer->valor;
                    } elseif ($customer->maquina  > 959){
                        $obj = new stdclass();
                        if($this->param['tipo'] == 'Semana' or $this->param['tipo'] == 'Mensal') {
                            $obj->maquinas = $customer->descricao.' - '.substr($customer->fechado,8,2).'/'.substr($customer->fechado,5,2);
                        } else {
                            $obj->maquinas = $customer->descricao;
                        }
                        $obj->contadores = $customer->valor;
                        $this->datagrid_desp->addItem($obj);
                        $despesas += $customer->valor;
                    }
                    if ($customer->maquina != 850) {
                        $dinheiro += $customer->valor;
                    }
                }
            }

//            if($this->param['tipo'] == 'Fechado' or $this->param['tipo'] == 'Semana' or $this->param['tipo'] == 'Mensal') {
            $saldo_clientes = $saldo_vales_anterior + ($vales * -1);
//            }

            $geral = $inicial+$reforco+$aporte+($conta_entra - $conta_saida)+$saldo_vales_anterior-$retirada;

            $obj = new stdclass();
            $obj->maquinas   = 'ENTRADAS';
            $obj->contadores = $conta_entra;
            $obj->manual     = $sangria;
            $obj->diferenca  = $sangria - $conta_entra;
            $this->datagrid_maq->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'PAGAMENTOS';
            $obj->contadores = $conta_saida;
            $obj->manual     = $pagamentos;
            $obj->diferenca  = $conta_saida - $pagamentos;
            $this->datagrid_maq->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'SALDO';
            $obj->contadores = $conta_entra - $conta_saida;
            $obj->manual     = $sangria - $pagamentos;
            $obj->diferenca  = ($sangria - $pagamentos) - ($conta_entra - $conta_saida);
            $this->datagrid_maq->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'CAIXA INICIAL';
            $obj->contadores = $inicial;
            $this->datagrid_rece->addItem($obj);
            if($valesclientes){
                $obj = new stdclass();
                $obj->maquinas   = 'SALDO DE VALES ANTERIOR';
                $obj->contadores = $saldo_vales_anterior;
                $this->datagrid_rece->addItem($obj);
            }
            if($reforco != 0) {
                foreach ($a_reforco as $key =>$item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_reforco[$key]->maquinas;
                    $obj->contadores = $a_reforco[$key]->contadores;
                    $this->datagrid_rece->addItem($obj);
                }
            }
            if($aporte != 0) {
                foreach ($a_aporte as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_aporte[$key]->maquinas;
                    $obj->contadores = $a_aporte[$key]->contadores;
                    $this->datagrid_rece->addItem($obj);
                }
            }
            if($retirada != 0) {
                foreach ($a_retiradas as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_retiradas[$key]->maquinas;
                    $obj->contadores = $a_retiradas[$key]->contadores;
                    $this->datagrid_rece->addItem($obj);
                }
            }
            $obj = new stdclass();
            $obj->maquinas = 'SALDO MÁQUINAS';
            $obj->contadores = $conta_entra - $conta_saida;
            $this->datagrid_rece->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL';
            $obj->contadores = $geral;
            $this->datagrid_rece->addItem($obj);

            if($this->param['tipo'] == 'Semana' or $this->param['tipo'] == 'Mensal') {
                // Recupera Fundo de Caixa
                $repository = new TRepository('movimento');
                $criteria = new TCriteria;
                $criteria->setProperty('order', 'fechado asc');
                $criteria->add(new TFilter('fechado', '>=', $this->param['primeirodia']));
                $criteria->add(new TFilter('fechado', '<=', $this->param['ultimodia']));
                $customers = $repository->load($criteria);
                $dinheiro = 0;
                $quedin = '';
                if ($customers) {
                    foreach ($customers as $customer) {
                        if ($quedin == $customer->fechado) {
                            if ($customer->maquina != 850) {
                                $dinheiro += $customer->valor;
                            }
                        } else {
                            $quedin = $customer->fechado;
                            if ($customer->maquina != 850) {
                                $dinheiro = $customer->valor;
                            }
                        }
                    }
                }
            }
            $obj = new stdclass();
            $obj->maquinas   = 'FUNDO DE CAIXA';
            $obj->contadores = $dinheiro;
            $this->datagrid_caixa->addItem($obj);
            if($ccred != 0) {
                $codigo = new codigo(951);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $ccred;
                $this->datagrid_caixa->addItem($obj);
            }
            if($cdeb != 0) {
                $codigo = new codigo(952);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cdeb;
                $this->datagrid_caixa->addItem($obj);
            }
            if($pix != 0) {
                $codigo = new codigo(953);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $pix;
                $this->datagrid_caixa->addItem($obj);
            }
            if($cheque != 0) {
                $codigo = new codigo(954);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cheque;
                $this->datagrid_caixa->addItem($obj);
            }
            if($dolar != 0) {
                $codigo = new codigo(955);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $dolar;
                $this->datagrid_caixa->addItem($obj);
            }
            if($card_1 != 0) {
                $codigo = new codigo(956);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $card_1;
                $this->datagrid_caixa->addItem($obj);
            }
            if($card_2 != 0) {
                $codigo = new codigo(957);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $card_2;
                $this->datagrid_caixa->addItem($obj);
            }
            if($valesclientes) {
                $obj = new stdclass();
                $obj->maquinas = 'SALDO DE VALES ATUAL';
                $obj->contadores = $saldo_clientes;
                $this->datagrid_caixa->addItem($obj);
            }
            $obj = new stdclass();
            $obj->maquinas = 'DESPESAS';
            $obj->contadores = $despesas*-1;
            $this->datagrid_caixa->addItem($obj);

            $obj = new stdclass();
            $situacao = (($despesas * -1) +$dinheiro+$ccred+$cdeb+$pix+$cheque+$dolar+$card_1+$card_2) - $geral + $saldo_clientes  ;
            if($situacao < 0){$obj->maquinas = 'FALTA DE CAIXA';}else{$obj->maquinas = 'SOBRA DE CAIXA';}
            $obj->contadores = $situacao * -1;
            $this->datagrid_caixa->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $dinheiro+$ccred+$cdeb+$pix+$cheque+$dolar+$card_1+$card_2+$saldo_clientes-$despesas-$situacao;
            $this->datagrid_caixa->addItem($obj);

            if($valesclientes) {
                $obj = new stdclass();
                $obj->maquinas = 'TOTAL';
                $obj->contadores = $vales;
                $this->datagrid_vales->addItem($obj);
            }

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $despesas;
            $this->datagrid_desp->addItem($obj);

            $azul=$dinheiro;
            $label = 'DINHEIRO('.number_format($dinheiro, 2, ',', '.').')';
            $taxa=0;
            If($ccred+$cdeb+$card_1+$card_2 != 0){
                $label = $label.' + CARTÃO('.number_format($ccred+$cdeb+$card_1+$card_2, 2, ',', '.').') ';
                if($txcard1 != 0 and $ccred != 0){
                    $taxa += $ccred * ($txcard1/100);
                }
                if($txcard2 != 0 and $cdeb != 0){
                    $taxa += $cdeb * ($txcard2/100);
                }
                if($txcard3 != 0 and $cdeb != 0){
                    $taxa += $card_1 * ($txcard3/100);
                }
                if($txcard4 != 0 and $cdeb != 0){
                    $taxa += $card_2 * ($txcard4/100);
                }
                if($taxa != 0){
                    $label = $label.'- TAXA CARTÃO '.'('.number_format($taxa, 2, ',', '.').')';
                }
                $azul += $ccred + $cdeb + $card_1 + $card_2 - $taxa;
            }
            If($pix != 0){$label = $label.' + PIX('.number_format($pix, 2, ',', '.').')';$azul += $pix;}
            If($cheque != 0){$label = $label.' + CHEQUE('.number_format($cheque, 2, ',', '.').')';$azul += $cheque;}
            If($dolar != 0){$label = $label.' + MOEDA ESTRANGEIRA('.number_format($dolar, 2, ',', '.').')';$azul += $dolar;}
            If($retirada != 0){$label = $label.' + RETIRADAS('.number_format($retirada, 2, ',', '.').')';$azul += $retirada;}
            $label = $label.' - CAIXA INICIAL('.number_format($inicial, 2, ',', '.').')';
            $azul -= $inicial;
            If($reforco != 0){$label = $label.' - REFORÇO('.number_format($reforco, 2, ',', '.').')';$azul -= $reforco;}
            If($aporte != 0){$label = $label.' - APORTE('.number_format($aporte, 2, ',', '.').')';$azul -= $aporte;}
            $label = $label.' = ';
            $label1 = new TLabel('');
            $label1->setValue(number_format($azul, 2, ',', '.'));
            if($azul < 0){$label1->style = "color:red";}else{$label1->style = "color:blue";}

            $this->frame->add(new TLabel($label));
            $this->frame->add($label1);

            // reset the criteria for record count
            $criteria->resetProperties();
            $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
            $this->CxInicial = $dinheiro;
            $this->VlInicial = $saldo_clientes;

            if($inicial == $dinheiro){
                TButton::disableField('form_atendente', 'fecha');
            } else{
                TButton::enableField('form_atendente', 'fecha');
            }

        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
        }
    }

    public function onFecha($param)
    {
        // define the delete action
        $action = new TAction(array($this, 'Fecha'));
        $action->setParameters($param); // pass the key parameter ahead

        // shows a dialog to the user
        new TQuestion('Confirma o fechamento do caixa ?', $action);
    }

    /**
     * Saves the cart
     */
    public function Fecha()
    {
        try
        {
            if($this->CxInicial < 0){throw new Exception('Caixa Negativo');};

            TTransaction::open('unit_database');

            $criteria = new TCriteria();
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $repository = new TRepository('movimento');
            $count = $repository->count($criteria);
            if($count < 3 and !(Utils::isAdmin())){throw new Exception('Caixa Vazio');};

            $conta_entra = leitura::where('fechado', 'IS', NULL)
                ->where('ok', '<>', 1)
                ->count();
            if($conta_entra > 0){throw new Exception('Existem máquinas sem Leitura');};

            $criteria = new TCriteria();
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $criteria->add(new TFilter('usuario', '<>', 0));
            $criteria->setProperty('order', 'id');
            $criteria->setProperty('limit' , 1);
            $repository = new TRepository('movimento');
            $result = $repository->load($criteria);
            $data = $result[0]->dia;

            $registro = new fecha;
            $registro->dia = $data;
            $registro->store();

            $registro = new Movimento;
            $registro->usuario = '0';
            $registro->maquina = '901';
            $registro->visita = '999';
            $registro->descricao = 'CAIXA INICIAL';
            $registro->valor = $this->CxInicial;
            $registro->store();

            $registro = new Movimento;
            $registro->usuario = '0';
            $registro->maquina = '850';
            $registro->visita = '999';
            $registro->descricao = 'VALES INICIAL';
            $registro->valor = $this->VlInicial;
            $registro->store();

            $object = new config;
            $object->{'id'}    = 'Reabre';
            $object->{'value'} = 1;
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Caixa fechado');
            $this->frame->clearChildren();
//            SystemNotification::register( 1, 'Caixa Fechado', 'Caixa Fechado', 'class=SystemNotificationList', 'Confirmar', 'fa fa-check-circle-o green' );
            $this->atualiza_users();
            AdiantiCoreApplication::loadPage('CaixaList');
//            $this->onReload();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onReabre($param)
    {
        // define the delete action
        $action = new TAction(array($this, 'Reabre'));
        $action->setParameters($param); // pass the key parameter ahead

        // shows a dialog to the user
        new TQuestion('Confirma a reabertura do caixa anterior ?', $action);
    }

    public function ReAbre()
    {
        try
        {
            TTransaction::open('unit_database');
// Consulta leitura
            $repository = new TRepository('leitura');
            $criteria = new TCriteria;
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $reads = $repository->load($criteria);
            $conta_entra = 0;
            foreach ($reads as $read){
                $conta_entra += (float)(($read->fim_entra - $read->ini_entra) * $read->credito);
            }
            if($conta_entra > 0 and !(Utils::isAdmin())){throw new Exception('Caixa atual com Leitura, Anterior não pode ser reaberto');};
// Consulta Transferência

            $last  = fecha::last();
            $data = $last->dia;
            /*
                        $repository = new TRepository('movimento');
                        $criteria = new TCriteria;
                        $criteria->add(new TFilter('fechado', '=', $data));
                        $criteria->add(new TFilter('descricao', 'like', 'TRANS%'));
                        $criteria->add(new TFilter('usuario', '>', 0));
                        $reads = $repository->load($criteria);
                        $quem_fechou = new SystemUser($reads[0]->usuario);
                        if($reads[0]->usuario <> TSession::getValue('userid') and TSession::getValue('userid') <> 1 ){throw new Exception('Caixa só pode ser reaberto pelo usuário <B>'.$quem_fechou->name.'</B>');}
            */
            $id = $last->id;
            $object = new fecha($id);
            $object->delete();

            movimento::where('fechado', 'is', NULL)
                ->where('maquina', '=', '901')
                ->delete();

            movimento::where('fechado', 'is', NULL)
                ->where('maquina', '=', '850')
                ->delete();

            movimento::where('fechado', 'is', NULL)
                ->set('fechado', '2019-01-01 00:00:00')
                ->update();

            movimento::where('fechado', '=', $data)
                ->set('fechado', NULL)
                ->update();

            leitura::where('fechado', 'is', NULL)
                ->delete();

            leitura::where('fechado', '=', $data)
                ->set('fechado', NULL)
                ->update();

            new TMessage('info', 'Caixa ReAberto');
            $this->frame->clearChildren();
            SystemNotification::register( 1, 'Caixa Reaberto '.config::getConfig('titulo'), 'Caixa Reaberto por '.TSession::getValue('username'), 'class=SystemNotificationList', 'Confirmar', 'fa fa-check-circle-o green' );
            TTransaction::close();
            AdiantiCoreApplication::loadPage('CaixaList');
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onSangria()
    {

        // form asking login and password
        $form = new TQuickForm('input_form');
        $form->style = 'padding:20px';

        $valor = new TEntry('valor');
        $valor->setInputType('tel');
        $valor->style = 'autocomplete="off"';


        $form->addQuickField('Valor da Sangria : ', $valor);

        $form->addQuickAction('Salvar', new TAction(array($this, 'onConfirm')), 'fa:check blue');

        // show the input dialog
        new TInputDialog('Lançamento de Sangria', $form);
        TScript::create('$("input[name=\'valor\']").focus();');

    }

    public function onConfirm($param)
    {
        $valor = str_replace(',', '.', $param['valor']);

        TTransaction::open('unit_database');
        $registro = new Movimento;
        $registro->usuario = TSession::getValue('userid');
        $registro->maquina = '904';
        $registro->descricao = 'SANGRIA';
        $registro->valor = ($valor);
        $registro->visita=999;
        if($valor != 0){
            $registro->store();
            TToast::show('success', 'Sangria registrada', 'top right', 'far:check-circle' );
        }
        TTransaction::close();
        $this->onReload();
    }

    public function onPrint($param)
    {
        // converts the HTML template into PDF
        $dompdf = new \Dompdf\Dompdf();
        $paginas = '.'.file_get_contents('app/resources/styles-print.html').$this->text_win.$this->datagrid_maq->getContents().$this->datagrid_rece->getContents().$this->datagrid_caixa->getContents();
        TTransaction::open('unit_database');
        if(config::getConfig('valesclientes')){
            $paginas = $paginas . $this->datagrid_vales->getContents();
        }
        TTransaction::close();
        $paginas = $paginas.$this->datagrid_desp->getContents().$this->frame->getContents();
        $dompdf->loadHtml($paginas);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();

        // write and open file
        $saida = 'app/output/caixa'.substr(time(),-4).'pdf';
        file_put_contents($saida, $dompdf->output());

        // open window to show pdf
        $window = TWindow::create('Caixa do Dia', 0.8, 0.8);
        $object = new TElement('iframe');
        $object->src  = $saida;
        $object->type  = 'application/pdf';
        $object->style = "width: 100%; height:calc(100% - 10px)";
        $window->add($object);
        $window->show();
    }

    public function atualiza_users()
    {
        TTransaction::open('permission');
        $usuarios = SystemUser::where('active', '=' ,'Y')->load();
        $hoje  = new DateTime('now');
        if ($usuarios) {
            foreach ($usuarios as $usuario) {
                if($usuario->custom_code != 'Admin' and $usuario->custom_code != 'Reserva' and !empty($usuario->accepted_term_policy_at)) {
                    $data_hora = new DateTime($usuario->accepted_term_policy_at);
                    $dias_dif = $hoje->diff($data_hora);
                    $dias_win = $dias_dif->days;
                    if ($dias_win > 15) {
                        $user = SystemUser::find($usuario->id);
                        if ($user instanceof SystemUser) {
                            $user->active = 'N';
                            $user->store();
                        }
                    }
                }
            }
        }
        TTransaction::close();
        return;
    }

    public function onWin()
    {
        return;
    }

    /**
     * Define when the action can be displayed
     */
    public function displayColumn( $object )
    {
        if ($object->maquinas == 'SALDO' and $object->diferenca != 0)
        {
            return TRUE;
        }
        return FALSE;
    }

}

/*
DELIMITER $$
DROP TRIGGER IF EXISTS `fecha`$$
CREATE TRIGGER `fecha` AFTER INSERT ON `tbl_fecha`
FOR EACH ROW
BEGIN
    DECLARE ultimo_dia DATETIME;
    SELECT dia INTO ultimo_dia FROM tbl_fecha ORDER BY id DESC LIMIT 1;
    UPDATE tbl_movi SET fechado = ultimo_dia WHERE fechado IS NULL;
    UPDATE tbl_movi SET fechado = NULL WHERE fechado = '2019-01-01 00:00:00';
    UPDATE tbl_leitura SET fechado = ultimo_dia WHERE fechado IS NULL;
	INSERT INTO tbl_leitura select null, `maquina`, `fim_entra`, `fim_sai`, `fim_entra`, `fim_sai`, `credito`, 0, NULL, `fabricante`, `porcento` from tbl_leitura where fechado =  ultimo_dia order by maquina;
END$$
DELIMITER ;

UPDATE `tbl_maquinas` SET `fabricante`='',`porcento`=0 WHERE 1;
UPDATE `tbl_leitura` SET `fabricante`='',`porcento`=0 WHERE 1;

show triggers;
*/