<?php
/**
 * WebcamForm Registration
 * @author  Imprime Informática
 */
class WebcamForm extends TPage
{
    protected $form; // form
    private $frameFoto;
    private $frameFotoWebCan;

    /**
     * Class constructor
     * Creates the page and the registration form
     */
    function __construct()
    {
        parent::__construct();

        TPage::include_js('app/lib/components/webcam/webcam.min.js');
        TPage::include_js('app/lib/components/webcam/webcam.js');
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Pessoa');
        $this->form->setFormTitle('Pessoa');
        $this->form->setFieldSizes('100%');

        // create the form fields
        $id                             = new TEntry('id');
        $datacadastro                   = new TDate('datacadastro');
        $datanascto                     = new TDate('datanascto');
        $fj                             = new TRadioGroup('fj');
        $nome                           = new TEntry('nome');
        $nomefantasia                   = new TEntry('nomefantasia');
        $situacao                       = new TRadioGroup('situacao');
        $situacao->addItems(array('0'=>'Ativo','1'=>'Inativo'));
        $situacao->setLayout('Horizontal');
        $situacao->setValue('0');
        $situacao->setUseButton();
        $nome_arq_foto                  = new TFile('nome_arq_foto');
        $nome_arq_foto->setAllowedExtensions( ['png', 'jpg'] );
        // complete upload action
        $nome_arq_foto->setCompleteAction( new TAction( array( $this, 'onCompleteFoto' ) ) );
        // Propriedades dos campos
        $id->setEditable(False);
        $datacadastro->setMask('dd/mm/yyyy');
        $datacadastro->setValue( date('d/m/Y') );
        $datacadastro->setTip('Data de Cadastro');
        $datanascto->setMask('dd/mm/yyyy');
        $fj->addItems(array('1'=>'Física','2'=>'Jurídica'));
        $fj->setLayout('Horizontal');
        $fj->setValue('1');
        $fj->setUseButton();
        $nome->addValidation('Nome/Razão Social', new TRequiredValidator);

        $nome_arq_foto->setSize('100%');
        // add one row for each form field
        $row = $this->form->addFields( [ new TLabel('ID'), $id ],
            [ new TLabel('Data Cadastro'), $datacadastro ],
            [ new TLabel('Situação'), $situacao],
            [ new TLabel('Data Nascto'),  $datanascto ],
            [ new TLabel('Pessoa'), $fj ] );
        $row->layout = ['col-sm-2', 'col-sm-3', 'col-sm-2', 'col-sm-3', 'col-sm-2'];
        $label_nome = new TLabel('Nome/Razão Social');
        $row = $this->form->addFields( [ $label_nome, $nome ],
            [ new TLabel('Nome Fantasia'), $nomefantasia ] );
        $label_nome->setFontColor('#FF0000');
        $row->layout = ['col-sm-6', 'col-sm-6'];
        $divisor = new TFormSeparator('Foto <span class="fa fa-long-arrow-down" aria-hidden="true"></span>', '#333333;margin-bottom:0', '18', '#000;margin-bottom:0');
        $divisor->style = 'background-color: #b1d4e8; padding-top: 1px';
        $this->form->addContent( [ $divisor ] );
        // campo para fazer upload de uma imagem qualquer (caso não use a webcam)
        $row = $this->form->addFields( [ new TLabel('Foto <b>(PNG ou JPG)</b>'), $nome_arq_foto ] );
        // div onde fica a foto se existir ou a camera apos clicar no botão Acessar Webcam
        $this->frameFoto = new TElement( 'div' );
        $this->frameFoto->id = 'user_foto_frame';
        $this->frameFoto->style = '';
        // div onde fica a foto tirada apos clicar no botão Bater Foto
        $this->frameFotoWebCan = new TElement( 'div' );
        $this->frameFotoWebCan->id = 'user_foto_frameWebCam';
        $this->frameFotoWebCan->style = '';
        // label que fica acima da div
        $labelframeFotoWebCan = new TLabel('Foto Tirada');
        $labelframeFotoWebCan->id = 'labelframeFotoWebCan';
        $labelframeFotoWebCan->style = 'display:none';

        // botão para acessar a webcam
        $btnWebcam = new TButton('btnWebcam');
        $btnWebcam->addFunction("setup(); $(this).hide(); $( '#labelAcessarWebcam' ).css( 'display', 'none' ); $( '#btnWebcamBaterFoto' ).css( 'display', '' ); $( '#labelWebcamBaterFoto' ).css( 'display', '' )");
        $btnWebcam->setImage('fa:camera');
        $btnWebcam->setLabel('Acessar Webcam');
        $btnWebcamLabel = new TLabel('&nbsp&nbsp');
        $btnWebcamLabel->id = 'labelAcessarWebcam';
        // botão para bater a foto
        $btnWebcamBaterFoto = new TButton('btnBaterFoto');
        $btnWebcamBaterFoto->addFunction("take_snapshot(); $( '#labelframeFotoWebCan' ).css( 'display', '' )");
        $btnWebcamBaterFoto->setImage('fa:camera');
        $btnWebcamBaterFoto->id = 'btnWebcamBaterFoto';
        $btnWebcamBaterFoto->style = 'display:none';
        $btnWebcamBaterFoto->setLabel('Bater Foto');
        $btnWebcamBaterFotoLabel = new TLabel('&nbsp&nbsp');
        $btnWebcamBaterFotoLabel->id = 'labelWebcamBaterFoto';
        $btnWebcamBaterFotoLabel->style = 'display:none';
        // adiciona os campos no form
        $row = $this->form->addContent( [ new TLabel('Formato 300x300 (Recomendado)'), $this->frameFoto ],
            [ $labelframeFotoWebCan, $this->frameFotoWebCan ],
            [ $btnWebcamLabel, $btnWebcam ],
            [ $btnWebcamBaterFotoLabel, $btnWebcamBaterFoto ] );
        $row->layout = ['col-sm-4', 'col-sm-4', 'col-sm-2', 'col-sm-2'];
        // campo text para receber a datauri da foto tirada (uso este campo para gerar/salvar a foto)
        $fotoWebcam = new TText('fotoWebcam');
        $fotoWebcam->id = 'idFotoWebcam';
        $fotoWebcam->style = 'display:none;';
        $this->form->addFields( [ $fotoWebcam ] );
        // create the form actions
        $btn = $this->form->addAction( _t('Save'), new TAction([$this, 'onSave']), 'fa:floppy-o' );
        $btn->class = 'btn btn-sm btn-primary';
        $btnNovo = $this->form->addAction( _t('New'), new TAction([$this, 'onEdit']), 'fa:eraser red' );
//        $this->form->addAction( _t('Back to the listing'), new TAction(['PessoasList', 'onReload']), 'fa:table blue' );
        $this->form->addHeaderAction( _t('Save'), new TAction([$this, 'onSave']), 'fa:save green' );
//        $this->form->addHeaderAction( _t('Back'), new TAction(['PessoasList', 'onReload']), 'fa:table blue' );
        // wrap the page content
        $vbox = new TVBox;
        $vbox->style = 'width: 98%';
        //$vbox->add(new TXMLBreadCrumb('menu.xml', 'PessoasList'));
        $vbox->add($this->form);

        // add the form inside the page
        parent::add($vbox);
    }
    /**
     * On complete upload
     */
    public static function onCompleteFoto( $param ) {
        //new TMessage('info', 'Upload completed: '.$param['nome_arq_foto']);
        //var_dump($param);
        // refresh photo_frame
        TScript::create( "$('#user_foto_frame').html('')" );
        TScript::create( "$('#user_foto_frame').append(\"<img style='max-width: 100%;' src='tmp/{$param[ 'nome_arq_foto' ]}'>\");" );
    }
    /**
     * method onSave()
     * Executed whenever the user clicks at the save button
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('db'); // open a transaction

            // get the form data into an active record Pessoa
            $object = $this->form->getData('Pessoa');
            //var_dump($object);
            //die;

            $this->form->validate(); // form validation
            // move a foto para a pasta
            $sourceUserFoto = 'tmp/' . $object->nome_arq_foto;
            $targetUserFoto = 'fotos/' . $object->nome_arq_foto;
            $finfoBanner = new finfo( FILEINFO_MIME_TYPE );
            //echo $sourceUserFoto . '<br>';
            //echo $targetUserFoto . '<br>';
            // validação do campo logo PNG/JPG
            if ( $object->nome_arq_foto != '' and file_exists( $sourceUserFoto ) and $finfoBanner->file( $sourceUserFoto ) != 'image/png' and $finfoBanner->file( $sourceUserFoto ) != 'image/jpeg' )
            {
                // excluir arquivo temporario
                unlink( $sourceUserFoto );
                // limpa o campo
                $object->nome_arq_foto = '';
                // retorna mensagem de erro
                throw new Exception( 'Foto inválida, escolha um arquivo no formato <strong>PNG</strong> ou <strong>JPG</strong> !' );
            }
            // nome fantasia igual ao nome se o fantasia estiver em banco
            if ( empty($object->nomefantasia) ):
                $object->nomefantasia = $object->nome;
            endif;
            // foto webcam
            if ( $object->fotoWebcam != '' )
            {
                $img = $object->fotoWebcam;
                $img = str_replace('data:image/jpeg;base64,', '', $img);
                $img = str_replace(' ', '+', $img);
                $data = base64_decode($img);
                //var_dump($data);
                $f = md5(uniqid(rand(), true)) . '_fotowebcam_pessoa.jpg';

                $success = file_put_contents('fotos/' . $f, $data);

                if ($success)
                {
                    $object->nome_arq_foto = $f;
                    $targetUserFoto = 'fotos/' . $object->nome_arq_foto;
                    //var_dump($object->nome_arq_foto);
                }
                // limpa o campo
                $object->fotoWebcam = ' ';
            }
            // salva o registro
            //$object->store(); // stores the object
            $this->form->setData($object); // keep form data


            TTransaction::close(); // close the transaction

            // if the user uploaded a source file
            if ( ($object->nome_arq_foto != '') and file_exists( $sourceUserFoto ) and ( $finfoBanner->file( $sourceUserFoto ) == 'image/png' or $finfoBanner->file( $sourceUserFoto ) == 'image/jpeg') )
            {
                // redimenciona se a larguda for maior que 800px
                $img = new Canvas( $sourceUserFoto );
                //var_dump($img);
                $larg = 300;
                $altu = 300;
                // se tem largura ou altura então redimenciona
                if ($larg != 0 || $altu != 0):
                    $img->redimensiona( $larg, $altu, 'preenchimento' );
                endif;
                // grava uma nova imagem com 90% de qualidade da original
                $img->grava( $sourceUserFoto, 90 );
                // move to the target directory
                rename( $sourceUserFoto, $targetUserFoto );
            }
            // exibe a imagem
            if ( $object->nome_arq_foto != '' ):
                $image = new TImage( $targetUserFoto );
                $image->style = 'max-width: 100%;';
                $this->frameFoto->clearChildren();
                $this->frameFoto->add( $image );
            endif;
            // neste reload vai colocar os endereços e contatos na tela
            $this->onReload( $param ); // reload
            $alert = new TAlert('info',TAdiantiCoreTranslator::translate( 'Record saved' ));
            $alert->id = 'alertOnSave';
            $alert->style = 'width: 98%';
            TScript::create( "$('#alertOnSave').fadeOut(5000);");
            parent::add( $alert );
            // shows the success message
            //new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'));
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', '<b>Erro</b> ' . $e->getMessage()); // shows the exception error message
            $data = $this->form->getData();
            $this->form->setData( $data ); // keep form data
            if ( $data->nome_arq_foto != '' ): // se existe informação no campo
                if ( file_exists( 'tmp/' . $data->nome_arq_foto ) ): // se tem arquivo na pasta temporaria
                    $image = new TImage( 'tmp/' . $data->nome_arq_foto );
                    $image->style = 'max-width: 100%;';
                    $this->frameFoto->add( $image );
                elseif ( file_exists( 'fotos/' . $data->nome_arq_foto ) ): // se não tem na pasta temporaria, então verifica a pasta padrão
                    $image = new TImage( 'fotos/' . $data->nome_arq_foto );
                    $image->style = 'max-width: 100%;';
                    $this->frameFoto->add( $image );
                endif;
            endif;
            // neste reload vai colocar os endereços e contatos na tela
            $this->onReload( $param ); // reload

            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * method onEdit()
     * Executed whenever the user clicks at the edit button da datagrid
     */
    function onEdit($param)
    {
        try
        {
            if (isset($param['key']))
            {
                $key=$param['key'];  // get the parameter $key
                TTransaction::open('db'); // open a transaction
                $object = new Pessoa($key); // instantiates the Active Record

                $this->form->setData($object); // fill the form

                // mostra imagem se existir
                if ( $object->nome_arq_foto ):
                    $image = new TImage( 'fotos/' . $object->nome_arq_foto );
                    $image->style = 'max-width: 100%;';
                    $this->frameFoto->add( $image );
                endif;
                // neste reload vai colocar os endereços na tela
                $this->onReload( $param ); // reload endereços
                TTransaction::close(); // close the transaction
            }
            else
            {
                //$this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', '<b>Erro</b> ' . $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Reload the item list
     * @param $param URL parameters
     */
    public function onReload($param)
    {
        $data = $this->form->getData();
        $this->loaded = TRUE;
    }

}
?>