<?php
class Foto extends TPage
{
    public function __construct($param)
    {
        parent::__construct();

        parent::setTargetContainer('adianti_right_panel');

        TPage::include_js('app/lib/components/webcam/webcam.min.js');
        TPage::include_js('app/lib/components/webcam/webcam.js');

        // creates the form
        $this->form = new BootstrapFormBuilder('form_foto');
        $this->form->setFormTitle('Foto Mquina '.$param['maquina_id']);
        $this->form->setFieldSizes('100%');

        // div onde fica a foto se existir ou a camera apos clicar no boto Acessar Webcam
        $this->frameFoto = new TElement( 'div' );
        $this->frameFoto->id = 'user_foto_frame';
        $this->frameFoto->style = '';

        // div onde fica a foto tirada apos clicar no boto Bater Foto
        $this->frameFotoWebCan = new TElement( 'div' );
        $this->frameFotoWebCan->id = 'user_foto_frameWebCam';
        $this->frameFotoWebCan->style = '';

        // label que fica acima da div
        $labelframeFotoWebCan = new TLabel('Foto Tirada');
        $labelframeFotoWebCan->id = 'labelframeFotoWebCan';
        $labelframeFotoWebCan->style = 'display:none';

        // boto para acessar a webcam
        $btnWebcam = new TButton('btnWebcam');
        $btnWebcam->addFunction("setup(); $(this).hide(); $( '#labelAcessarWebcam' ).css( 'display', 'none' ); $( '#btnWebcamBaterFoto' ).css( 'display', '' ); $( '#labelWebcamBaterFoto' ).css( 'display', '' )");
        $btnWebcam->setImage('fa:camera');
        $btnWebcam->setLabel('Acessar Webcam');
        $btnWebcamLabel = new TLabel('&nbsp&nbsp');
        $btnWebcamLabel->id = 'labelAcessarWebcam';

        // boto para bater a foto
        $btnWebcamBaterFoto = new TButton('btnBaterFoto');
        $btnWebcamBaterFoto->addFunction("take_snapshot(); $( '#labelframeFotoWebCan' ).css( 'display', '' )");
        $btnWebcamBaterFoto->setImage('fa:camera');
        $btnWebcamBaterFoto->id = 'btnWebcamBaterFoto';
        $btnWebcamBaterFoto->style = 'display:none';
        $btnWebcamBaterFoto->setLabel('Bater Foto');

        $btnWebcamBaterFotoLabel = new TLabel('&nbsp&nbsp');
        $btnWebcamBaterFotoLabel->id = 'labelWebcamBaterFoto';
        $btnWebcamBaterFotoLabel->style = 'display:none';

        // adiciona os campos no form
        $this->form->addContent( [ new TLabel('Foto da Leitura'), $this->frameFoto, $this->frameFotoWebCan ]);
        $this->form->addContent( [ $btnWebcamLabel, $btnWebcam, $labelframeFotoWebCan, $btnWebcamBaterFoto ]);

        /*        // adiciona os campos no form
                $row = $this->form->addContent( [ new TLabel('Foto da Leitura'), $this->frameFoto, $this->frameFotoWebCan ],
                    [ $btnWebcamLabel, $btnWebcam ],
                    [ $btnWebcamBaterFotoLabel, $btnWebcamBaterFoto ] );
                $row->layout = ['col-sm-4', 'col-sm-4', 'col-sm-2', 'col-sm-2'];
        */
        // campo text para receber a datauri da foto tirada (uso este campo para gerar/salvar a foto)
        $fotoWebcam = new TText('fotoWebcam');
        $fotoWebcam->id = 'idFotoWebcam';
        $fotoWebcam->style = 'display:none;';
        $this->form->addFields( [ $fotoWebcam ] );

        // create the form actions
        $btn = $this->form->addAction( _t('Save'), new TAction([$this, 'onSave']), 'fa:floppy-o' );
        $btn->class = 'btn btn-success btn-lg btn-block';

        // create the form actions
        $btn1 = $this->form->addAction( _t('Back'), new TAction([$this, 'onClose']), 'fa:floppy-o' );
        $btn1->class = 'btn btn-danger btn-lg btn-block';

        // wrap the page content
        $vbox = new TVBox;
        $vbox->style = 'width: 100%';
        $vbox->add($this->form);

        // add the form inside the page
        parent::add($vbox);
    }

    /**
     * on close
     */
    public static function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }

    public function onSave()
    {
        try
        {
            $this->form->validate(); // validate form data
            $data = $this->form->getData();

                // Testa Foto
                if($data->fotoWebcam == ""){
                    throw new Exception('Leitura sem Foto');
                }

                $leitura = new stdclass();
                $leitura->maquina = 1;
                $diaFecha = '2025-04-04 00:00:00';
                $casa='Teste';
                //$casa=config::getConfig('titulo');

                if ( $data->fotoWebcam != '' )
                {
                    $img = $data->fotoWebcam;
                    $img = str_replace('data:image/jpeg;base64,', '', $img);
                    $img = str_replace(' ', '+', $img);
                    $data = base64_decode($img);

                    $f = $casa.'_'.$diaFecha.'_'.$leitura->maquina.'.jpg';
//                $f = $casa.'_'.$diaFecha.'_'.$leitura->maquina.'_'.date("Y-m-d H:i:s");

                    $success = file_put_contents('app/images/leituras/' . $f, $data);
                }

            TScript::create("Template.closeRightPanel()");

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }
}
