<?php
class EscolheMes extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->tipo = $param['tipo'];

        $this->ini = parse_ini_file('app/config/application.ini', true);

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        TTransaction::open('unit_database');
        $repository = new TRepository('fecha');
        $criteria = new TCriteria();
        $criteria->setProperty('order', 'dia desc');
        $reads = $repository->load($criteria);
        TTransaction::close();

        $dias = array();
        $fechas = array();
        $diant = '';
        arsort($reads);
        foreach ($reads as $key=>$read){
            if(substr($read->dia,5,2) <> $diant){$dias[$read->id]=substr($read->dia,5,2).'/'.substr($read->dia,0,4);$fechas[]=$read->dia;}
            $diant = substr($read->dia,5,2);
        }
        $dia_view = new TCombo('combo');
        $dia_view->addItems($dias);
        $acao = new TAction(array($this, 'onExitDia'));
        $acao->setParameter('tipo',$this->tipo);
        $dia_view->setChangeAction($acao);

        // add validators
        $dia_view->addValidation('Dia', new TRequiredValidator);

        // define some attributes
        $dia_view->style = 'font-size: 17pt; height: 30px; text-align: center;';

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        if($this->tipo == 'Caixa' ) {
            $cell = $row->addCell(new TLabel('CAIXA DO MÊS A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Fecha' ){
            $cell = $row->addCell( new TLabel('FECHAMENTO DO MÊS A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Leitura' ) {
            $cell = $row->addCell(new TLabel('LEITURA DO MÊS A VISUALIZAR'))->style = 'text-align: center;';
        }

        // create the field labels
        $lab_cli = new TLabel('MÊS');
        $lab_cli->setFontSize(17);
        $lab_cli->setFontFace('Trebuchet MS');

        $table_item->addRowSet($lab_cli)->style = 'text-align: center;';
        $table_item->addRowSet($dia_view)->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($dia_view));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item);
        parent::add($vbox);
    }

    public static function onExitDia($param)
    {
        TTransaction::open('unit_database');
        $fecha = new fecha($param['key']);
        $dia = $fecha->dia;
        // close the transaction
        TTransaction::close();

        $dates = array();
        $dates['tipo'] = 'Mensal';
        $dates['primeirodia'] = $dia;
        $dates['ultimodia'] = $dia;

        // reload the listing
        if($param['tipo'] == 'Caixa' ) {
            TApplication::gotoPage('CaixaList',NULL, $dates);
        }elseif($param['tipo'] == 'Fecha' ) {
            TApplication::gotoPage('FechaSemList',NULL, $dates);
        }elseif($param['tipo'] == 'Leitura' ) {
            TApplication::gotoPage('LeituraSemList',NULL, $dates);
        }
    }
}
