<?php
class EscolheMaq extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        // creates the items form and add a table inside
        $this->form_item = new TForm('form');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        $maquina_id = new TDBCombo('maquina_id','unit_database','maquina','id','id','id');
        $maquina_id->setChangeAction(new TAction(array($this, 'onExitMaquina')));

        // add validators
        $maquina_id->addValidation('Máquina', new TRequiredValidator);

        // define some attributes
        $maquina_id->style = 'font-size: 17pt; height: 30px; text-align: center;';

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        $cell = $row->addCell(new TLabel('CORREÇÃO DE LEITURA'))->style = 'text-align: center;';

        // create the field labels
        $lab_cli = new TLabel('MÁQUINA');
        $lab_cli->setFontSize(17);
        $lab_cli->setFontFace('Trebuchet MS');

        $table_item->addRowSet($lab_cli)->style = 'text-align: center;';
        $table_item->addRowSet($maquina_id)->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($maquina_id));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item);
        parent::add($vbox);
    }

    public static function onExitMaquina($param)
    {
        TTransaction::open('unit_database');
        TApplication::gotoPage('LeiCorrForm',NULL, $param);
    }
}
